Extension { #name : 'BtreeRangeComparisonQuerySpec' }

{ #category : 'Instance Creation' }
BtreeRangeComparisonQuerySpec class >> key: aKey selector: aSelector and: aKey2 selector: aSelector2 [

| new |
new := self new key: aKey selector: aSelector.
new key2: aKey2 selector2: aSelector2.
^new

]

{ #category : 'Querying' }
BtreeRangeComparisonQuerySpec >> _addRootObjectsFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex into: collection [
  | sel1 sel2 |
  sel1 := self performSelector: opCode.
  sel2 := self performSelector: opCode2.
  startIndex to: endIndex by: entrySize do: [ :i | | aKey |
    aKey := aLeafNode keyAt: i.
    (self compare: aKey using: sel1 and: sel2)
      ifTrue: [ collection add: (aLeafNode rootObjectAt: i) ] ]

]

{ #category : 'Querying' }
BtreeRangeComparisonQuerySpec >> _addValuesFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex into: collection [
  | sel1 sel2 |
  sel1 := self performSelector: opCode.
  sel2 := self performSelector: opCode2.
  startIndex to: endIndex by: entrySize do: [ :i |
    | aKey |
    aKey := aLeafNode _basicAt: i + 1.
    (self compare: aKey using: sel1 and: sel2)
      ifTrue: [ collection add: (aLeafNode _basicAt: i) ] ]

]

{ #category : 'Querying' }
BtreeRangeComparisonQuerySpec >> _traverseValuesFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex previous: previousValue into: collection [
  | val prevVal aKey sel1 sel2 |
  sel1 := self performSelector: opCode.
  sel2 := self performSelector: opCode2.
  prevVal := previousValue.
  startIndex to: endIndex by: entrySize do: [ :i |
    aKey := aLeafNode _basicAt: i + 1.
    val := aLeafNode _basicAt: i.
    ((self compare: aKey using: sel1 and: sel2) and: [ val ~~ prevVal ])
      ifTrue: [
        rangeIndex
          _addAllFor: val
          into: collection
          offset: offset
          pathTerm: pathTerm ].
    prevVal := val ].
  ^ prevVal

]

{ #category : 'Comparing' }
BtreeRangeComparisonQuerySpec >> compare: entry using: selector1 and: selector2 [
  ^ (entry perform: selector1 with: key)
    and: [ entry perform: selector2 with: key2 ]

]

{ #category : 'Comparing' }
BtreeRangeComparisonQuerySpec >> compareKey: entry [
  ^ (entry perform: (self performSelector: opCode) with: key)
    and: [ entry perform: (self performSelector: opCode2) with: key2 ]

]

{ #category : 'Updating' }
BtreeRangeComparisonQuerySpec >> key2: aKey2 selector2: aSelector2 [

key2 := aKey2.
opCode2 := self operationSelectors indexOf: aSelector2.

]
