Extension { #name : 'BtreeQuerySpec' }

{ #category : 'Querying' }
BtreeQuerySpec >> _addRootObjectsFrom: aLeafNode
entrySize: entrySize
start: startIndex
end: endIndex
into: collection [

startIndex to: endIndex by: entrySize do: [ :i |
  collection add: (aLeafNode rootObjectAt: i).
].

]

{ #category : 'Querying' }
BtreeQuerySpec >> _addValuesFrom: aLeafNode
entrySize: entrySize
start: startIndex
end: endIndex
into: collection [

startIndex to: endIndex by: entrySize do: [ :i |
  collection add: (aLeafNode _basicAt: i).
].

]

{ #category : 'Querying' }
BtreeQuerySpec >> _traverseValuesFrom: aLeafNode
entrySize: entrySize
start: startIndex
end: endIndex
previous: previousValue
into: collection [

  | val prevVal |
prevVal := previousValue.
startIndex to: endIndex by: entrySize do: [ :i |
val := aLeafNode _basicAt: i.
  (val == prevVal)
     ifFalse: [
       rangeIndex _addAllFor: val
         into: collection
         offset: offset
         pathTerm: pathTerm
     ].
  prevVal := val
].
^prevVal

]

{ #category : 'Querying' }
BtreeQuerySpec >> addRootObjectsFrom: aLeafNode
start: startIndex
end: endIndex
into: collection [

^ aLeafNode
    _addRootObjects: self
    start: startIndex
    end: endIndex
    into: collection

]

{ #category : 'Querying' }
BtreeQuerySpec >> addValuesFrom: aLeafNode
start: startIndex
end: endIndex
into: collection [

^ aLeafNode
    _addValues: self
    start: startIndex
    end: endIndex
    into: collection

]

{ #category : 'Testing' }
BtreeQuerySpec >> canUseOptimizedComparison [

  ^ false

]

{ #category : 'Updating' }
BtreeQuerySpec >> rangeIndex: aRangeIndex offset: anOffset pathTerm: aPathTerm [

rangeIndex := aRangeIndex.
offset := anOffset.
pathTerm := aPathTerm.

]

{ #category : 'Querying' }
BtreeQuerySpec >> traverseValuesFrom: aLeafNode
start: startIndex
end: endIndex
previous: previousValue
into: collection [

^ aLeafNode
    _traverseValues: self
    start: startIndex
    end: endIndex
    previous: previousValue
    into: collection

]
