Extension { #name : 'BtreePlusUnicodeRangeComparisonQuerySpec' }

{ #category : 'Accessing' }
BtreePlusUnicodeRangeComparisonQuerySpec >> collator [
  ^ collator

]

{ #category : 'Accessing' }
BtreePlusUnicodeRangeComparisonQuerySpec >> collator: anIcuCollator [
  collator :=  anIcuCollator

]

{ #category : 'Comparing' }
BtreePlusUnicodeRangeComparisonQuerySpec >> compare: entry using: sel1 and: sel2 [
  ^ (entry perform: sel1 with: key with: self collator)
    and: [ entry perform: sel2 with: key2 with: self collator ]

]

{ #category : 'Updating' }
BtreePlusUnicodeRangeComparisonQuerySpec >> key: aKey selector: aSelector [
  key := aKey.
  opCode := self operationSelectors indexOf: aSelector.
  selector := self unicodePerformSelector: opCode

]

{ #category : 'Updating' }
BtreePlusUnicodeRangeComparisonQuerySpec >> key2: aKey2 selector2: aSelector2 [
  key2 := aKey2.
  opCode2 := self operationSelectors indexOf: aSelector2.
  selector2 := self unicodePerformSelector: opCode2

]

{ #category : 'Accessing' }
BtreePlusUnicodeRangeComparisonQuerySpec >> performSelectors [
  "Returns an Array of comparison operation selectors whose ordering corresponds
 to the operation selectors."

  ^ #(#'_idxForCompareLessThan:collator:' #'_idxForCompareGreaterThan:collator:' #'_idxForCompareEqualTo:collator:' #'==' #'_idxForCompareLessThanOrEqualTo:collator:' #'_idxForCompareGreaterThanOrEqualTo:collator:' #'_idxForCompareNotEqualTo:collator:' #'~~')

]
