Extension { #name : 'BtreePlusRangeComparisonQuerySpec' }

{ #category : 'Instance Creation' }
BtreePlusRangeComparisonQuerySpec class >> key: aKey selector: aSelector and: aKey2 selector: aSelector2 [

| new |
new := self new key: aKey selector: aSelector.
new key2: aKey2 selector2: aSelector2.
^new

]

{ #category : 'Updating' }
BtreePlusRangeComparisonQuerySpec >> _addRootObjectsFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex into: collection [
   (self optimizingComparison and: [ self canUseOptimizedComparison ])
    ifTrue: [ startIndex to: endIndex by: entrySize do: [ :i | collection add: (aLeafNode rootObjectAt: i) ] ]
    ifFalse: [ startIndex to: endIndex by: entrySize do: [ :i | | aKey |
        aKey := aLeafNode keyAt: i.
        (self compare: aKey using: selector and: selector2)
          ifTrue: [ collection add: (aLeafNode rootObjectAt: i) ] ] ]

]

{ #category : 'Comparing' }
BtreePlusRangeComparisonQuerySpec >> compare: entry using: sel1 and: sel2 [
  ^ (entry perform: sel1 with: key) and: [ entry perform: sel2 with: key2 ]

]

{ #category : 'Comparing' }
BtreePlusRangeComparisonQuerySpec >> compareKey: entry [
  ^ (entry perform: selector with: key)
    and: [ entry perform: selector2 with: key2 ]

]

{ #category : 'Updating' }
BtreePlusRangeComparisonQuerySpec >> key2: aKey2 selector2: aSelector2 [
  key2 := aKey2.
  self optimizingComparison
    ifTrue: [ selector2 := aSelector2 ]
    ifFalse: [ opCode2 := self operationSelectors indexOf: aSelector2.
      selector2 := self performSelector: opCode2 ]

]
