Extension { #name : 'BtreeOptimizedComparison' }

{ #category : 'Comparison Operators' }
BtreeOptimizedComparison >> compareKey: aKey equalTo: aValue [

^ aKey = aValue

]

{ #category : 'Comparison Operators' }
BtreeOptimizedComparison >> compareKey: aKey greaterThan: aValue [

^ aKey > aValue

]

{ #category : 'Comparison Operators' }
BtreeOptimizedComparison >> compareKey: aKey greaterThanOrEqualTo: aValue [

^ aKey >= aValue

]

{ #category : 'Comparison Operators' }
BtreeOptimizedComparison >> compareKey: aKey lessThan: aValue [

^ aKey < aValue

]

{ #category : 'Comparison Operators' }
BtreeOptimizedComparison >> compareKey: aKey lessThanOrEqualTo: aValue [

^ aKey <= aValue

]

{ #category : 'Testing' }
BtreeOptimizedComparison >> satisfiableQueryGreaterThan: val1
andEquals: bool1
andLessThan: val2
andEquals: bool2 [

  "nil is a special case for optimized comparisons ... allowed in queries, but not as value in index"
  ^ val1 ifNil: [ true ]
    ifNotNil: [
      ((val1 > val2) or:
        [ (val1 = val2) and: [ (bool1 and:[bool2]) not ] ] ) not ]

]
