Extension { #name : 'BtreeComparisonForUnicodeCompare' }

{ #category : 'initialization' }
BtreeComparisonForUnicodeCompare >> collator: anIcuCollator [
  collator := anIcuCollator

]

{ #category : 'Comparison Operators' }
BtreeComparisonForUnicodeCompare >> compareKey: aKey equalTo: aValue [
  ^ aKey _idxForCompareEqualTo: aValue collator: collator

]

{ #category : 'Comparison Operators' }
BtreeComparisonForUnicodeCompare >> compareKey: aKey greaterThan: aValue [
  ^ aKey _idxForCompareGreaterThan: aValue collator: collator

]

{ #category : 'Comparison Operators' }
BtreeComparisonForUnicodeCompare >> compareKey: aKey greaterThanOrEqualTo: aValue [
  ^ aKey _idxForCompareGreaterThanOrEqualTo: aValue collator: collator

]

{ #category : 'Comparison Operators' }
BtreeComparisonForUnicodeCompare >> compareKey: aKey lessThan: aValue [
  ^ aKey _idxForCompareLessThan: aValue collator: collator

]

{ #category : 'Comparison Operators' }
BtreeComparisonForUnicodeCompare >> compareKey: aKey lessThanOrEqualTo: aValue [
  ^ aKey _idxForCompareLessThanOrEqualTo: aValue collator: collator

]

{ #category : 'Testing' }
BtreeComparisonForUnicodeCompare >> satisfiableQueryGreaterThan: val1 andEquals: bool1 andLessThan: val2 andEquals: bool2 [
  ^ ((val1 _idxForCompareGreaterThan: val2 collator: collator)
    or: [
      (val1 _idxForCompareEqualTo: val2 collator: collator)
        and: [ (bool1 and: [ bool2 ]) not ] ])
    not

]
