"
AzureCredentials is designed to hold credentials for accessing Azure.
All instance variables are Strings.

AzureCredentials are used to unlock AzureDataKey objects. See the
comments in the AzureDataKey class for more information.
"
Class {
	#name : 'AzureCredentials',
	#superclass : 'AbstractCloudCredentials',
	#instVars : [
		'clientId',
		'clientSecret',
		'tenantId'
	],
	#category : 'Credentials'
}

{ #category : 'Instance Creation' }
AzureCredentials class >> newWithClientId: clId clientSecret: clSecret tenantId: tenId [

^self new
	clientId: clId ;
	clientSecret: clSecret ;
	tenantId: tenId;
	yourself

]

{ #category : 'Accessing' }
AzureCredentials >> clientId [
	^clientId

]

{ #category : 'Updating' }
AzureCredentials >> clientId: newValue [
	clientId := newValue

]

{ #category : 'Accessing' }
AzureCredentials >> clientSecret [
	^clientSecret

]

{ #category : 'Updating' }
AzureCredentials >> clientSecret: newValue [
	clientSecret := newValue

]

{ #category : 'Accessing' }
AzureCredentials >> tenantId [
	^tenantId

]

{ #category : 'Updating' }
AzureCredentials >> tenantId: newValue [
	tenantId := newValue

]
