"
AwsCredentials is designed to hold credentials for accessing Amazon
Web Services (AWS). All instance variables are Strings. sessionId 
optional and may be set to an empty string if not needed.

AwsCredentials are used to unlock AwsDataKey objects. See the
comments in the AwsDataKey class for more information.
"
Class {
	#name : 'AwsCredentials',
	#superclass : 'AbstractCloudCredentials',
	#instVars : [
		'accessKeyId',
		'secretKeyId',
		'sessionId'
	],
	#category : 'Credentials'
}

{ #category : 'Instance Creation' }
AwsCredentials class >> newWithAccessKeyId: keyId secretKeyId: secretId [
^ self newWithAccessKeyId: keyId secretKeyId: secretId sessionId: ''

]

{ #category : 'Instance Creation' }
AwsCredentials class >> newWithAccessKeyId: keyId secretKeyId: secretId sessionId: sessId [

^self new
	accessKeyId: keyId ;
	secretKeyId: secretId ;
	sessionId: sessId;
	yourself

]

{ #category : 'Accessing' }
AwsCredentials >> accessKeyId [
	^accessKeyId

]

{ #category : 'Updating' }
AwsCredentials >> accessKeyId: newValue [
	accessKeyId := newValue

]

{ #category : 'Accessing' }
AwsCredentials >> secretKeyId [
	^secretKeyId

]

{ #category : 'Updating' }
AwsCredentials >> secretKeyId: newValue [
	secretKeyId := newValue

]

{ #category : 'Accessing' }
AwsCredentials >> sessionId [
	^sessionId

]

{ #category : 'Updating' }
AwsCredentials >> sessionId: newValue [
	sessionId := newValue

]
