Extension { #name : 'AbstractIndexSpecification' }

{ #category : 'instance creation' }
AbstractIndexSpecification class >> path: aString lastElementClass: aClass [

	^(self new)
		path: aString;
		lastElementClass: aClass;
		yourself

]

{ #category : 'accessing' }
AbstractIndexSpecification >> _createIndex [
  self subclassResponsibility: #'_createIndex'

]

{ #category : 'private' }
AbstractIndexSpecification >> _validateLastElementClassOn: anNsc [
  "noop"



]

{ #category : 'private' }
AbstractIndexSpecification >> _validatePathOn: anNsc [
  anNsc _checkIndexPathExpression: self path

]

{ #category : 'private' }
AbstractIndexSpecification >> _validateSpecificationOn: anNsc [
  self _validateLastElementClassOn: anNsc.
  self _validatePathOn: anNsc

]

{ #category : 'accessing' }
AbstractIndexSpecification >> collator [
  "No collator associate with non-Unicode indexes"

  ^ nil

]

{ #category : 'accessing' }
AbstractIndexSpecification >> createIndexOn: anNsc [
  IndexManager current createIndexFor: anNsc fromSpec: self

]

{ #category : 'accessing' }
AbstractIndexSpecification >> defaultEnumeratedPathTermClass [
  ^ self legacyIndex
    ifTrue: [ EnumeratedPathTerm ]
    ifFalse: [ GsEnumeratedPathTerm ]

]

{ #category : 'accessing' }
AbstractIndexSpecification >> defaultPathTermClass [
  ^ self requirePathTerms
    ifTrue: [ self legacyIndex
        ifTrue: [ PathTerm ]
        ifFalse: [ GsPathTerm ] ]
    ifFalse: [ self legacyIndex
        ifTrue: [ OptionalPathTerm ]
        ifFalse: [ GsOptionalPathTerm ] ]

]

{ #category : 'accessing' }
AbstractIndexSpecification >> defaultSelectorPathTermClass [
  ^ self legacyIndex
    ifTrue: [ SelectorPathTerm ]
    ifFalse: [ GsSelectorPathTerm ]

]

{ #category : 'accessing' }
AbstractIndexSpecification >> defaultSetValuedPathTermClass [
  ^ self legacyIndex
    ifTrue: [ SetValuedPathTerm ]
    ifFalse: [ GsSetValuedPathTerm ]

]

{ #category : 'accessing' }
AbstractIndexSpecification >> indexType [

	^ self subclassResponsibility: #indexType

]

{ #category : 'accessing' }
AbstractIndexSpecification >> indexTypePrintString [
  self subclassResponsibility: #'indexTypePrintString'

]

{ #category : 'testing' }
AbstractIndexSpecification >> isIndexedOn: anNsc [
  ^ (anNsc _findIndexesWithPath: self path asArrayOfPathTerms) isEmpty not

]

{ #category : 'accessing' }
AbstractIndexSpecification >> lastElementClass [

	^lastElementClass

]

{ #category : 'accessing' }
AbstractIndexSpecification >> lastElementClass: aClass [

	lastElementClass := aClass

]

{ #category : 'accessing' }
AbstractIndexSpecification >> legacyIndex [
  | val |
  val := self dynamicInstVarAt: #'legacyIndex'.
  ^ val ifNil: [ true ]

]

{ #category : 'accessing' }
AbstractIndexSpecification >> legacyIndex: aBool [
  self dynamicInstVarAt: #'legacyIndex' put: aBool

]

{ #category : 'accessing' }
AbstractIndexSpecification >> optimizedComparison [
  | val |
  val := self dynamicInstVarAt: #'optimizedComparison'.
  ^ val ifNil: [ false ]

]

{ #category : 'accessing' }
AbstractIndexSpecification >> optimizedComparison: aBool [
  self dynamicInstVarAt: #'optimizedComparison' put: aBool

]

{ #category : 'accessing' }
AbstractIndexSpecification >> optionalPathTerms [
  ^ self requirePathTerms not

]

{ #category : 'accessing' }
AbstractIndexSpecification >> optionalPathTerms: aBool [
  self requirePathTerms: aBool not

]

{ #category : 'accessing' }
AbstractIndexSpecification >> options [
  | options |
  options := GsIndexOptions basicNew.
  self reducedConflict
    ifTrue: [ options setReducedConflict ]
    ifFalse: [ options clearReducedConflict ].
  self optionalPathTerms
    ifTrue: [ options setOptionalPathTerms ]
    ifFalse: [ options clearOptionalPathTerms ].
  self legacyIndex
    ifTrue: [
      options setLegacyIndex.
      options clearBtreePlusIndex.
      options clearOptimizedComparison "by definition" ]
    ifFalse: [
      options setBtreePlusIndex.
      options clearLegacyIndex.
      "optimized comparisons only apply to btreePlus index"
      self optimizedComparison
        ifTrue: [ options setOptimizedComparison ]
        ifFalse: [ options clearOptimizedComparison ] ].
  ^ options

]

{ #category : 'accessing' }
AbstractIndexSpecification >> options: aGsIndexOptions [
  self optionalPathTerms: aGsIndexOptions optionalPathTerms.
  self reducedConflict: aGsIndexOptions reducedConflict.
  self legacyIndex: aGsIndexOptions legacyIndex.
  self optimizedComparison: aGsIndexOptions optimizedComparison

]

{ #category : 'accessing' }
AbstractIndexSpecification >> path [

	^path

]

{ #category : 'accessing' }
AbstractIndexSpecification >> path: aString [

	path := aString

]

{ #category : 'printing' }
AbstractIndexSpecification >> printOptionsSelectorOn: aStream [
  aStream
    lf;
    tab;
    tab;
    nextPutAll: 'options: '.
  self options printOn: aStream

]

{ #category : 'printing' }
AbstractIndexSpecification >> printSelectorOn: aStream [

  aStream nextPutAll: self indexTypePrintString.
  self path isEmpty
    ifTrue: [ aStream nextPutAll: ': ''''' ]
    ifFalse: [ aStream nextPutAll: ': ''each.' , self path , '''' ].
  self lastElementClass ifNotNil: [ :cls | aStream
        lf;
        tab;
        tab;
        nextPutAll: 'lastElementClass: ' , cls name asString ].
  self collator ifNotNil: [ :icuColl | aStream
        lf;
        tab;
        tab;
        nextPutAll:
            'collator: (IcuCollator forLocaleNamed: ' , icuColl locale name printString
                , ')' ].
  self printOptionsSelectorOn: aStream

]

{ #category : 'accessing' }
AbstractIndexSpecification >> reducedConflict [
  | val |
  val := self dynamicInstVarAt: #'reducedConflict'.
  ^ val ifNil: [ false ]

]

{ #category : 'accessing' }
AbstractIndexSpecification >> reducedConflict: aBool [
  self dynamicInstVarAt: #'reducedConflict' put: aBool

]

{ #category : 'accessing' }
AbstractIndexSpecification >> removeIndexFrom: anNsc [
  (self isIndexedOn: anNsc)
    ifTrue: [ anNsc removeEqualityIndexOn: self path ]

]

{ #category : 'accessing' }
AbstractIndexSpecification >> requirePathTerms [
  requirePathTerms ifNil: [ requirePathTerms := true ].
  ^ requirePathTerms

]

{ #category : 'accessing' }
AbstractIndexSpecification >> requirePathTerms: aBool [
  requirePathTerms := aBool

]
