Extension { #name : 'AbstractDictionary' }

{ #category : 'Object Canonicalization' }
AbstractDictionary >> _canonicalizeReferencesUsingPolicy: aReferencingObjectPolicy [

	^aReferencingObjectPolicy canonicalizeReferencesInDictionary: self

]

{ #category : 'Private' }
AbstractDictionary >> _printAssociations [
  | keys rpt |
  keys := SortedCollection withAll: self keys .
  rpt := String new .
  keys do:[:k | 
    | val  |
    val := self at: k .
    val == self 
      ifFalse:[ | str | 
        str := (k -> val ) printString .
				str size > 100 ifTrue:[ str size: 100 ; add:' ...' ].
				rpt add: str ; lf .
      ] ifTrue:[ rpt add: k printString ; add: '->(self)'; lf ].
  ].
  ^ rpt
]

{ #category : 'Repository Conversion' }
AbstractDictionary >> fixRefsAfterConversion [

"Default Dictionary method for fixing references to
 ObsLargePositiveInteger and ObsLargeNegativeInteger
 instances that can now be represented as a
 SmallInteger and Floats and SmallFloats which can now be represented as
 a SmallDouble."

| array convBm |

convBm := (GsBitmap newForHiddenSet: #Conversion).
(convBm includes: self) 
        ifTrue:[^false]. "already fixed this one"

"Fix inst var refs first"
self fixInstVarRefsAfterConversion.

"now handle keys and values"
array := { } .
self keysAndValuesDo:[:k :v|
        (k needsFixingAfterConversion or:[v needsFixingAfterConversion])
                ifTrue:[array add: k; add: v.].
        ].
1 to: array size by: 2 do:[:n| |k v newKey newValue|
        k := array at: n.
        v := array at: (n + 1).
        self removeKey: k.
        k needsFixingAfterConversion
                ifTrue:[newKey := k + 0]
                ifFalse:[newKey := k].
        v needsFixingAfterConversion
                ifTrue:[newValue := v + 0]
                ifFalse:[newValue := v].
        self at: newKey put: newValue.
].
convBm add: self.
^true

]

{ #category : 'Accessing' }
AbstractDictionary >> keys [

"Returns a Set containing the receiver's keys."

| aSet |
aSet := Set new .
self keysDo: [ :key | aSet add: key ].
^ aSet

]
