"
AbstractCloudKey is an abstract superclass to support keys 
required for authentication with services in the cloud.
"
Class {
	#name : 'AbstractCloudKey',
	#superclass : 'Object',
	#category : 'Credentials'
}

{ #category : 'Exceptions' }
AbstractCloudKey class >> errorClass [
  ^ self subclassResponsibility
]

{ #category : 'Exceptions' }
AbstractCloudKey >> assertNotSolo [

GsSession isSolo ifTrue:[
  self errorClass signal: 'An operation was attempted which is not allowed in solo mode.' ].
]

{ #category : 'Exceptions' }
AbstractCloudKey >> assertNoUncommittedChanges [

System needsCommit ifTrue:[ self _error: #rtErrAbortWouldLoseData ]

]

{ #category : 'Exceptions' }
AbstractCloudKey >> assertUnlocked [

self isUnlocked
	ifFalse:[ self errorClass signal: 'An operation was attempted which requires the key to be unlocked, however the key is locked'].

]

{ #category : 'Exceptions' }
AbstractCloudKey >> errorClass [
  ^ self class errorClass
]
