Extension { #name : 'AbstractBagEnumerator' }

{ #category : 'private' }
AbstractBagEnumerator >> _createIvOffsetCache [
  self _createIvOffsetCacheFor: evaluator

]

{ #category : 'private' }
AbstractBagEnumerator >> _createIvOffsetCacheFor: anEvaluator [
  | cache |
  cache := anEvaluator _createIvOffsetCache.
  ivOffsetCache1 := cache at: 1.
  ivOffsetCache2 := cache at: 2

]

{ #category : 'private' }
AbstractBagEnumerator >> _findNonNilRootValues: aValue1 and: aValue2 do: aBlock [
  1 to: bag size do: [ :i |
    | obj |
    (obj := bag _at: i) ~~ nil
      ifTrue: [
        (self value: aValue1 and: aValue2 test: obj)
          ifTrue: [ aBlock value: obj ] ] ]

]

{ #category : 'private' }
AbstractBagEnumerator >> _findRootValues: aValue1 and: aValue2 do: aBlock [
  1 to: bag size do: [ :i |
    | obj |
    obj := bag _at: i.
    (self value: aValue1 and: aValue2 test: obj)
      ifTrue: [ aBlock value: obj ] ]

]

{ #category : 'private' }
AbstractBagEnumerator >> _findTraversedCollectionBasedValues: aValue1 and: aValue2 do: aBlock [
  | obj |
  1 to: bag size do: [ :i |
    (obj := bag _at: i) ~~ nil
      ifTrue: [
        evaluator
          traverse: obj
          do: [ :endObj |
            (self value: aValue1 and: aValue2 test: endObj)
              ifTrue: [ aBlock value: obj ] ] ] ]

]

{ #category : 'private' }
AbstractBagEnumerator >> _findTraversedValues: aValue1 and: aValue2 do: aBlock [
  "This method assumes that the evaluator is not over a collection-based instance variable."

  1 to: bag size do: [ :i |
    | obj |
    (obj := bag _at: i) ~~ nil
      ifTrue: [
        | endObj |
        endObj := evaluator
          _traverse: obj
          cachedOffsets: ivOffsetCache2
          cachedClasses: ivOffsetCache1
          incomplete: #'_incompletePathTraversal'.
        endObj ~~ #'_incompletePathTraversal'
          ifTrue: [
            (self value: aValue1 and: aValue2 test: endObj)
              ifTrue: [ aBlock value: obj ] ] ] ]

]

{ #category : 'private' }
AbstractBagEnumerator >> _traversePathForObject: obj [
  "This method assumes that the evaluator is not over a collection-based instance variable."

  ^ evaluator
    _traverse: obj
    cachedOffsets: ivOffsetCache2
    cachedClasses: ivOffsetCache1
    incomplete: #'_incompletePathTraversal'

]

{ #category : 'accessing' }
AbstractBagEnumerator >> doBlock: aBlock [
  doBlock := aBlock

]

{ #category : 'accessing' }
AbstractBagEnumerator >> evaluator: anEvaluator [
  evaluator := anEvaluator.
  bag := evaluator nsc _asIdentityBag

]

{ #category : 'querying' }
AbstractBagEnumerator >> findAllValuesFor: aValue [
  ^ self findAllValuesFor: aValue and: nil

]

{ #category : 'querying' }
AbstractBagEnumerator >> findAllValuesFor: aValue1 and: aValue2 [
  | theBlock tmpHolder result |
  theBlock := doBlock.
  theBlock
    ifNil: [
      tmpHolder := evaluator tmpHolder.
      theBlock := [ :each | tmpHolder add: each ] ].
  result := evaluator isIndexOnRootNsc
    ifTrue: [ self _findRootValues: aValue1 and: aValue2 do: theBlock ]
    ifFalse: [
      evaluator isCollectionBased
        ifTrue: [ self _findTraversedCollectionBasedValues: aValue1 and: aValue2 do: theBlock ]
        ifFalse: [
          self _createIvOffsetCache.
          self _findTraversedValues: aValue1 and: aValue2 do: theBlock ] ].
  ^ doBlock ifNil: [ tmpHolder completeBag ] ifNotNil: [ result ]

]

{ #category : 'accessing' }
AbstractBagEnumerator >> selector: aSelector [
  selector := aSelector

]

{ #category : 'traversing' }
AbstractBagEnumerator >> traversePathFor: anObject endObjDo: aBlock [
  | endObj |
  self _createIvOffsetCache.
  endObj := self _traversePathForObject: anObject.
  endObj ~~ #'_incompletePathTraversal'
    ifTrue: [ aBlock value: endObj ]

]

{ #category : 'testing' }
AbstractBagEnumerator >> value: aValue and: ignored test: endObj [
  ^ endObj perform: selector with: aValue

]
