"
Upgrade3Init is a class used during image upgrade.  
Methods should only be executed via the image upgrade scripts.
"
Class {
	#name : 'Upgrade3Init',
	#superclass : 'PrivateObject',
	#category : 'Kernel-Build'
}

{ #category : 'Image Upgrade' }
Upgrade3Init class >> _checkObsoleteClasses: obsoleteClassNames [
  "Check for obsolete classes in obsoleteClassNames"
  | obsDict |
  obsDict := Globals at: #ObsoleteClasses otherwise: nil.
  obsoleteClassNames do:[:sym | 
    (Globals includesKey: sym) ifTrue:[ 
      | assoc |
      assoc := Globals associationAt: sym  .
      Globals removeAssociation: assoc .
      obsDict addAssociation: assoc .
    ].
  ].
]

{ #category : 'Image Upgrade' }
Upgrade3Init class >> _checkObsoleteDisallowedSubclasses [
  "Check for obsolete classes used in _disallowSubclasses"
  self _checkObsoleteClasses: 
        #( ObsoleteMetaclass CompiledMethod UnimplementedFloat1 UnimplementedFloat2 
             MethodContext Block SelectionBlock JISCharacter StackSegment StackBuffer 
             Activation Process ExecutableBlock SimpleBlock ComplexBlock ComplexVCBlock
             GsMethod )
]

{ #category : 'Image Upgrade' }
Upgrade3Init class >> _checkObsoleteInstancesDisallowed [
  "Check for obsolete classes used in _buildInstancesDisallowed"
  self _checkObsoleteClasses: 
             #( Activation Block GsMethod ComplexBlock ComplexVCBlock ExecutableBlock 
                  JISCharacter ObsoleteMetaclass MethodContext Process SelectionBlock
                  SimpleBlock StackBuffer StackSegment )
]

{ #category : 'Image Upgrade' }
Upgrade3Init class >> _checkObsoleteMigrateGroups [
  "Check for obsolete classes used in _migrateGroups"
  self _checkObsoleteClasses: 
        #( CanonicalStringDictionary )
]

{ #category : 'Image Upgrade' }
Upgrade3Init class >> _checkObsoleteVmClasses [
  "Check for obsolete classes used in _checkVmClasses"
  self _checkObsoleteClasses: 
             #( AbstractCharacter )
]

{ #category : 'Image Upgrade' }
Upgrade3Init class >> _disallowSubclasses [
| list blk obsDict |
  self _checkObsoleteDisallowedSubclasses.
  obsDict := Globals at: #ObsoleteClasses otherwise: nil.
	blk := [:cls | "_unsafeDisallowSubclasses"
          cls _unsafeAt: 2 "offset of format"
             put: (cls format bitOr: 32 "subclasses disallowed bit") .
          cls _refreshClassCache: false
       ].
  list := { Behavior . Class . (obsDict at: #ObsoleteMetaclass) . Repository . UserProfileSet .
     AbstractUserProfileSet .
     (obsDict at: #CompiledMethod) . Float . DecimalFloat . SmallFloat . SmallDouble .
     Symbol . DoubleByteSymbol .
     (obsDict at: #UnimplementedFloat1) . (obsDict at: #UnimplementedFloat2) .
     (obsDict at: #MethodContext) . (obsDict at: #Block) . (obsDict at: #SelectionBlock) .
     GsObjectSecurityPolicy . SymbolList . System . UndefinedObject . UserProfile . Boolean .
     Character . SmallInteger . Integer . LargeInteger .
     (obsDict at: #JISCharacter) . (obsDict at: #StackSegment) .
     (obsDict at: #StackBuffer) . (obsDict at: #Activation) . (obsDict at: #Process) . 
     VariableContext . BlockClosure .

     ExecBlock . (obsDict at: #ExecutableBlock) . (obsDict at: #SimpleBlock) . 
     (obsDict at: #ComplexBlock) . (obsDict at: #ComplexVCBlock) . 
     ExecBlock0 . ExecBlock1 . ExecBlock2 . ExecBlock3 . ExecBlock4 . ExecBlock5 . ExecBlockN .
     (obsDict at: #GsMethod) . GsNMethod . GsNativeCode .
     GsProcess . GsMethodDictionary . GsStackBuffer .

     SelectBlock . BasicSortNode .
     RcIndexDictionary . NscBuilder .

     "PathTerm . ConstrainedPathTerm . SetValuedPathTerm"  "fix bug 11484"
     }.
  list do: [ :aClass | blk value: aClass ].

  list do: [ :aClass |
     aClass subclassesDisallowed ifFalse:[ ^ 'Error on ' , aClass name ].
     ] .
]

{ #category : 'Image Upgrade' }
Upgrade3Init class >> _setByteSwizzles [
" Set the NbyteWords swizzle option in some byte format classes, so it
  shows up in the result of Class>>definition.  ominit.c synthesizes the
  in-memory swizzle info for the classes if needed when class is faulted in.
  Part of fix 47516."
| blk |
GsFile gciLogServer:'_setByteSwizzles'.
blk := [:cls :aSym | | fmt newFmt |
   fmt := cls format .
   newFmt := cls _addByteSwizzle: aSym toFormat: fmt newClassName: cls name signed: false .
   newFmt = fmt ifTrue:[
     GsFile gciLogServer: '  ',cls name, ' no change'.
   ] ifFalse:[
     cls _unsafeAt: 2 put: newFmt .
     GsFile gciLogServer: '  ',cls name, ' old format ', fmt asString, ' new format ', newFmt asString
   ].
].
{ DoubleByteString .
  DoubleByteSymbol .
  Unicode16  .
  Utf16
} do:[:aCls | blk value: aCls value: #'2byteWords' ].

{ LargeInteger  .
  QuadByteString .
  QuadByteSymbol .
  Unicode32 .
  SmallFloat .
  BitSet .
} do:[:aCls | blk value: aCls value: #'4byteWords' ].

{  Float
} do:[ :aCls | blk value: aCls value: #'8byteWords' ].

]
