"
An abstract parser for all parsers in PetitParser. Subclasses implement #parseOn: to perform 
the actual recursive-descent parsing. All parsers support a variety of methods to perform an 
actual parse, see the methods in the #parsing protocol. Parsers are combined with a series 
of operators that can be found in the #operations protocol.

Instance Variables:
	properties	<Dictionary>	Stores additional state in the parser object.

GemStone implementation notes:

CharacterCollection>>#asParser
	We have this instead of String>>#asParser
Collection>>#asParser
	We use #isKindOf: instead of #isCharacter
DoubleByteSymbol>>#asParser
	We added this
Interval>>#asParser
	We use #isKindOf: instead of #isCharacter
PositionableStream
	#peekTwice and #asPetitStream moved to PositionableStreamPortable
PositionableStreamPortable>>#collection
	We added as compatibility with PositionableStream in Pharo/Squeak
PPActionParser>>#setBlock:
	Modified to support Symbol as argument
PPCompositeParser>>#productionAt:ifAbsent:
	Remove #asString since we store instVarNames as symbols
PPForwardingParser
	We use this instead of #becomeForward: in PPParser>>#def:
PPLiteralObjectParser>>#caseInsensitive
	We use #isEquivalent: instead of #sameAs:
PPLiteralSequenceParser>>#caseInsensitive
	We use #isEquivalent: instead of #sameAs:
PPParser>>#def:
	Modified since we dont have #becomeForward:
PPParser>>#queryToken
	Added to support GsQueryTokenParser
PPRepeatingParser>>#initialize
	Modified to use #maximumValue instead of #maxValue
PPRepeatingParser>>#printOn:
	Modified to use #maximumValue instead of #maxValue
PPSequenceParser>>#permutation:
	Modified to use #_isInteger instead of #isInteger
PPStream
	Superclass changed to ReadStream Portable
PPStream>>#back and #peekBack
	Added to match Pharo/Squeak PositionableStream
PPStream>>#printOn:
	Modified to avoid non-Ascii character in source code
PPToken
	Remove NewLineParser from class variable (permissions and commit conflicts)
QuadByteSymbol>>#asParser
	Added
String>>#asParser
	Moved to CharacterCollection
Text>>#asPetitStream
	Not supported

PPParser>>#matchingRangesIn:do:
	Should change to match since no recognizable difference

"
Class {
	#name : 'PPParser',
	#superclass : 'Object',
	#instVars : [
		'properties'
	],
	#category : 'PetitParser-Parsers'
}
