"
If enabled, LogRotateNotification is signalled asynchronously when a gem or topaz -l
process receives the SIGHUP signal.

It is the responsibility of the application to install a handler for LogRotateNotification,
and in that handler send #reopen to any instances of GsFile and GsLog that should have
log rotate behavior.

By default LogRotateNotification is not enabled. 
If enabled, it is not disabled by default after being signalled.
"

Class {
	#name : 'LogRotateNotification',
	#superclass : 'Notification',
	#category : 'Exceptions'
}

{ #category : 'Control' }
LogRotateNotification class >> disableSignalling [
  System _updateSignalErrorStatus: 11 toState: false
]

{ #category : 'Control' }
LogRotateNotification class >> enableSignalling [
  System _updateSignalErrorStatus: 11 toState: true 
]

{ #category : 'Control' }
LogRotateNotification class >> signallingEnabled [
  ^ System _signalErrorStatus: 11
]

{ #category : 'Handling' }
LogRotateNotification >> defaultAction [
"Return an error to the controlling debugger or GCI client .
 See AbstractException>>defaultAction for documentation."

 ^ self _signalToDebugger
]
