"
Instances of Int32Array are byte format arrays that store 32 bit signed integers.
For an instance loaded into memory, the integers are in machine native byte order.
"
Class {
	#name : 'Int32Array',
	#superclass : 'Uint32Array',
	#gs_options : [
		'signed4byteWords'
	],
	#category : 'Collections-NumericArrays'
}

{ #category : 'Updating' }
Int32Array >> at: anOffset put: aValue [

"aValue must be a SmallInteger representable as a 32bit unsigned integer.
 returns aValue ."

<primitive: 1075>
| min max |
aValue _validateClass: SmallInteger .
min := -2147483648 .
max := 2147483647 .
(aValue < min or:[ aValue > max]) ifTrue:[
  aValue _error: #rtErrArgOutOfRange args:{ min . max }
].
(anOffset _isSmallInteger) ifTrue: [
  ((anOffset > (self size + 1)) or: [anOffset < 1]) ifTrue: [
    ^ self _errorIndexOutOfRange: anOffset
  ]
] ifFalse: [
  ^ self _errorNonIntegerIndex: anOffset
] .
self _primitiveFailed: #at:put: args: { anOffset . aValue }

]
