"
Instances of Int16Array are byte format arrays that store 16 bit signed integers.
For an instance loaded into memory, the integers are in machine native byte order.
"
Class {
	#name : 'Int16Array',
	#superclass : 'Uint16Array',
	#gs_options : [
		'signed2byteWords'
	],
	#category : 'Collections-NumericArrays'
}

{ #category : 'Updating' }
Int16Array >> at: anOffset put: aValue [

"aValue must be a SmallInteger representable as a 16bit signed integer.
 returns aValue ."
 
<primitive: 254>
aValue _validateClass: SmallInteger .
(aValue < -32768 or:[ aValue > 32767]) ifTrue:[
  aValue _error: #rtErrArgOutOfRange args:{ -32768 . 32767 }
].
(anOffset _isSmallInteger) ifTrue: [
  ((anOffset > (self size + 1)) or: [anOffset < 1]) ifTrue: [
    ^ self _errorIndexOutOfRange: anOffset
  ] 
] ifFalse: [
  ^ self _errorNonIntegerIndex: anOffset
] . 
self _primitiveFailed: #at:put: args: { anOffset . aValue }

]
