"
GsTsExternalSession is an implementation of AbstractExternalSession that
uses the threads-safe GCI library, $GEMSTONE/lib/libgcits*.so, to
communicate to the Gem which is servicing an instance of GsTsExternalSession .

A loaded libgcits library is represented by an instance of GciTsLibrary, which
is a parameter to GsTsExternalSession.

While the target repository is often the same version of GemStone as the 
executing session, you may also login to repository running a different version
of GemStone. GciTsLibrary supports loading a libgcits library from a different 
version of GemStone; this requires cpp; you should have gcc/g++ installed.

Objects returned by remote session executions can be any type of object. 
 - It is recommended to return specials if possible. 
 - Return values that are kinds of strings are automatically converted to 
   a string in the local session. 
 - Other kinds of byte objects are returned as ByteArrays and may need manual 
   conversion.
 - All other objects are returned as a 3-element Array containing the OOP of 
   the result, the OOP of the class of the result, and the size of the result.

The oops of return values that are byte format, such as strings, are added to 
the remote session's export set, but are automatically cleared (when the number 
of these reaches 100).  The oops of non-special, non-byte format objects must 
be manually removed from the remote session's export set using releaseOop: or 
releaseOops:, if the remote session has memory pressure. 

GsTsExternalSession is not supported on AIX.

instVar notes:
  nbCallInProgress values 
    0 no call ,
    1 nbLogin in progress
    2 execution in progress 
    3 execution in progress for getting error details

  objInfoBuffers  is a three element array , 
      CByteArray   sizeof(GciTsObjInfo)
      CByteArray  of intVar values 
      Array of oops to release

Example:
| sess |
sess := GsTsExternalSession newDefault .
sess username: 'DataCurator'; password: 'swordfish' ; login .
sess executeString: 'System stoneName'.
sess executeBlock: [2 + 5].
sess logout.

Example loading a different GciTsLibrary version:
| param sess |
param := GemStoneParameters new
  gemStoneName: 'gemstone353';
  username: 'DataCurator';
  password: 'swordfish';
  gemService: '!#netldi:ldi_353!gemnetobject';
  yourself.
sess := GsTsExternalSession parameters: param
  library: (GciTsLibrary
     newForVersion: '3.5.3'
     product: '/lark/users/gsadmin/GemStone64_353').
sess login.
sess executeString: 'System stoneName'.
sess logout.

Example using a non-blocking login and execute:
| sess result |
sess := GsTsExternalSession newDefault .
sess username: 'DataCurator'; password: 'swordfish' ; nbLogin .
sess waitForReadReady.
sess nbLoginFinished. 
sess nbExecute: '2 + 5'.
sess nbResult.
sess logout.

"
Class {
	#name : 'GsTsExternalSession',
	#superclass : 'AbstractExternalSession',
	#instVars : [
		'tsSession',
		'socket',
		'gciErr',
		'callouts',
		'lib',
		'objInfoBuffers',
		'stoneSessionId',
		'gemProcessId',
		'parameters',
		'performArgs',
		'lastResult',
		'nbCallInProgress',
		'nbLoginSession',
		'stoneSessionSerial',
		'logger',
                'gemVersion'
	],
	#gs_options : [
		'instancesNonPersistent'
	],
	#category : 'ExternalSessions'
}
