"
The class GsRangeQueryPredicate is a predicate in a GsQueryFormula. This class is a concrete subclass of GsAbstractQueryPredicate and applies two operators, two constant operands and a path operand.

The constant operands may be a literal (instance of GsConstantReferenceAssociation) or a variable (instance of GsVariableReferenceAssociation).

The path operand is expected to be an instance of a GsQueryPathReferenceAssociation.

Each operator may be one of the range comparison operators: < > <= >=. To qualify as a normalized GsRangeQueryPredicate, if one of the operators is < or <= then the other operator must also be  < or <=, alternately, if one of the operators is > or >= then the other operator must also be  > or >=. 
"
Class {
	#name : 'GsRangeQueryPredicate',
	#superclass : 'GsAbstractQueryPredicate',
	#instVars : [
		'operand1',
		'operator1',
		'path',
		'operator2',
		'operand2',
		'evaluator'
	],
	#category : 'Indexing-Query'
}
