"
Instances of GsEventLog hold collections of log entries, each representing an item recorded 
in a logical log file.  There is a shared, system-wide instance in the class instance variable. 
All users are allowed to add and remove entries from this log.  

The entries are stored in an instance of RcArray, allowing concurrent writes of log entries.  
Note that the order of elements is based on the order in which the commits occurred, 
while entry timestamps reflect the time at which the entry was created.

GsEventLog may hold both application (user) events and system events.  
User entires can be added in two ways: class convenience methods such as logError:, logInfo, etc., 
or by creating an instance of GsEventLogEntry and sending addToLog.  
System events should be added only by GemStone code (no events are added at this time).
To restrict modifying or removing events, execute GsEventLog entriesUnmodifiable.  
After this is executed, new entries to the log are made invariant and the standard delete methods 
will not delete them.  However, they are not protected from delete using private delete protocol. 
System events are also protected from modification or delete, other than using private delete 
protocol.

Removing entries is subject to commit conflict, it is recommended to lock the event log prior to 
delete.
"
Class {
	#name : 'GsEventLog',
	#superclass : 'Object',
	#instVars : [
		'entryArray',
		'newEntriesInvariant'
	],
	#classInstVars : [
		'CurrentLog'
	],
	#category : 'System-EventLog'
}
