Extension { #name : 'SymbolDictionary' }

{ #category : 'Browser Methods' }
SymbolDictionary class >> _listTraitsIn: dictArg matching: aString [

"Returns a String containing names of traits, one per line; or false.
 If dictArg == nil, list the whole symbolList .
 If aString ~~ nil, limit result to those traits for which
    (aTrait name includesString: aString)==true .
 If aDict is not a kind of SymbolDictionary, returns false.
 Used by Topaz."
| list result |
dictArg  ifNil:[ list := GsSession currentSession symbolList ]
      ifNotNil:[ (dictArg isKindOf: self ) ifFalse:[ ^ false ].
                 list := { dictArg } ].
result := String new .
list do:[:aDict | | aSet sortedNames |
  aSet := SymbolSet new .
  aDict associationsDo:[:assoc |
    (assoc _value isTrait) ifTrue:[ aSet add: assoc key ].
  ].
  aString ifNil:[
    aSet size > 0 ifTrue:[
      result size > 0 ifTrue:[ result lf ].
      result addAll: 'dictionary ' ;
             addAll: (aDict name ifNil:[ '(unnamed)' ]); lf .
    ].
  ] ifNotNil:[
    aSet := aSet select:[:n | n includesString: aString]
  ].
  sortedNames := SortedCollection withAll: aSet .
  1 to: sortedNames size do:[:j |
    result add:'  '; addAll: (sortedNames at: j); lf .
  ].
].
^ result
]
