"
AbstractTrait is an abstract superclass to support Traits, which allow sets of 
methods to be shared between classes. 
"
Class {
	#name : 'AbstractTrait',
	#superclass : 'Object',
	#instVars : [
		'traitImpl'
	],
	#category : 'Kernel-Methods'
}

{ #category : 'browser methods' }
AbstractTrait >> _categoriesReport [

"Returns an Array containing key-value pairs from the receiver's categories
 for specified environment.
 The key in each key-value pair is the name of a category; the value in each
 key-value pair is a sorted Array of selectors.

 Used by the Topaz 'trlist categories' command."

| result k sz sortedCats catMap |
sortedCats := SortedCollection new:[ :a :b | a key <= b key ].
catMap := SymbolDictionary new.
self categoriesDo:[ :selector :categName|
  (catMap at: categName asSymbol ifAbsentPut: [ SymbolSet new ]) add: selector
].

catMap keysAndValuesDo:[ :categName :selectors|
  sortedCats add: ( Association newWithKey: categName value: selectors)
].
result := Array new: (sz := sortedCats size) * 2  .
k := 1 .
1 to: sz do:[:j | | anAssoc |
   anAssoc := sortedCats at: j .
   result at: k put: anAssoc key .
   result at: k + 1 put: (Array withAll:(SortedCollection withAll: anAssoc _value)).
   k := k + 2 .
].
^ result .
]

{ #category : 'browser methods' }
AbstractTrait >> _categoryOfSelector: selector [
	"Returns the category of the given selector, or 'unknown' if it isn't found."

	^ self subclassResponsibility: #'_categoryOfSelector: '
]

{ #category : 'private' }
AbstractTrait >> _extraDictAt: key [
	"Return value for key in extraDict.
   Return nil if extraDict or the key are not present. "

	^ self traitImpl _extraDictAt: key
]

{ #category : 'private' }
AbstractTrait >> _extraDictAt: key put: value [
	"Add value for key to extraDict.  Create extraDict if not present. "

	^ self traitImpl _extraDictAt: key put: value
]

{ #category : 'private' }
AbstractTrait >> _extraDictRemoveKey: key [
 " Remove key/value from extraDict.
    Dont care if extraDict or the key itself are not present. "

	^ self traitImpl _extraDictRemoveKey: key
]

{ #category : 'private' }
AbstractTrait >> _instVarsEqual: anArrayOfInstvarNames [
	"Return true if the argument matches the instVarNames
   defined by the receiver , false otherwise."

  | ary |
	ary := self instVarNames .
  ary _isArray ifFalse:[ Error signal:'bad instVarNames']. "TODO delete assert"
	^ ary	= (anArrayOfInstvarNames collect: [ :n | n asSymbol ])
]

{ #category : 'browser methods' }
AbstractTrait >> _selectorsReport: envId matching: aString primitivesOnly: primsBoolean includeDeprecated: inclDeprecBool [
	"Used by topaz (and GBS?).
  Result is a sorted SequenceableCollection  of Symbols, plus an optional string 'Omitted .. deprecated methods'.
  aString if not nil restricts the result to only include those selectors containing
  the case-insensitive substring aString .
  primsBoolean if true further restricts the result to only include only
  selectors of methods which are primitives."

	^ self
		subclassResponsibility:
			#'_selectorsReport:matching:primitivesOnly:includeDeprecated:'
]

{ #category : 'browser methods' }
AbstractTrait >> _topazMethodAt: aString [
	"Returns a GsNMethod, or signals an Error."

	^ self subclassResponsibility: #'_topazMethodAt:'
]

{ #category : 'accessing' }
AbstractTrait >> addDependent: aClass [
	self subclassResponsibility: #'addDependent:'
]

{ #category : 'formatting' }
AbstractTrait >> asString [

^ self name asString
]

{ #category : 'browser methods' }
AbstractTrait >> categoriesDo: aBlock [
	^ self subclassResponsibility: #'categoriesDo:'
]

{ #category : 'browser methods' }
AbstractTrait >> categoryOfSelector: selector [
	"Returns the category of the given selector, or nil if it isn't found."

	^ self subclassResponsibility: #'categoryOfSelector: '
]

{ #category : 'accessing' }
AbstractTrait >> classTrait [
	"answer the class trait ... by default the receiver .. override in subclass to provide correct answer"

	^ self
]

{ #category : 'compiling' }
AbstractTrait >> compile: sourceString [
	self subclassResponsibility: #'compile:'
]

{ #category : 'compiling' }
AbstractTrait >> compile: sourceString category: aCategoryString [
	self subclassResponsibility: #'compile:category:'
]

{ #category : 'fileout' }
AbstractTrait >> fileOutTraitOn: stream [
	^ self traitImpl fileOutTraitOn: stream
]

{ #category : 'browser methods' }
AbstractTrait >> includesSelector: aString [
	^ self subclassResponsibility: #'includesSelector:'
]

{ #category : 'accessing' }
AbstractTrait >> instanceTrait [
	"answer the instance trait ... by default the receiver .. override in subclass to provide correct answer"

	^ self
]

{ #category : 'testing' }
AbstractTrait >> isTrait [
	"Answer true if the receiver is a Trait"
	^ true
]

{ #category : 'accessing' }
AbstractTrait >> localSelectors [
	^ self subclassResponsibility: #'localSelectors'
]

{ #category : 'accessing' }
AbstractTrait >> name [
	^ self traitImpl name
]

{ #category : 'updating' }
AbstractTrait >> objectSecurityPolicy: anObjectSecurityPolicy [
	"Assigns the receiver and subcomponents to the given security policy."

	super objectSecurityPolicy: anObjectSecurityPolicy.
	traitImpl objectSecurityPolicy: anObjectSecurityPolicy
]

{ #category : 'updating' }
AbstractTrait >> removeAllMethods [
	self subclassResponsibility: #'removeAllMethods'
]

{ #category : 'updating' }
AbstractTrait >> removeSelector: aString [
	self subclassResponsibility: #'removeSelector:'
]

{ #category : 'accessing' }
AbstractTrait >> sourceCodeAt: selectorSymbol [
	^ self subclassResponsibility: #'sourceCodeAt:'
]

{ #category : 'accessing' }
AbstractTrait >> traitImpl [
	^traitImpl
]

{ #category : 'accessing' }
AbstractTrait >> traitImpl: object [
	traitImpl := object
]
