Extension { #name : 'SimpleTestResourceTestCase' }

{ #category : 'accessing' }
SimpleTestResourceTestCase class >> resources [
	^ { SimpleTestResource }

]

{ #category : 'utility' }
SimpleTestResourceTestCase >> clearOuterResourceStateDuring: aBlock [
	"This self-testing test must clear the outer state of its resources before starting and after finishing, so that it can construct test cases and suites of itself and test them."

	self assert: SimpleTestResource isAlreadyAvailable
		description: 'The resource was not set up for the test'.
	SimpleTestResource reset.
	self deny: SimpleTestResource isAlreadyAvailable
		description: 'The resource was still set up before we began the run'.
	^aBlock sunitEnsure:
		[self deny: SimpleTestResource isAlreadyAvailable
			description: 'The resource was still set up after we finished the run'.
		SimpleTestResource isAvailable.
		self assert: SimpleTestResource isAlreadyAvailable
			description: 'The resource was not set up again after the test'].

]

{ #category : 'private' }
SimpleTestResourceTestCase >> dummy [
	self assert: resource hasSetup
		description: 'This test uses a resource but it was not set up'.
	self setRun.
	self assert: resource hasRun
		description: 'This test uses a resource but we could not interact with it'.

]

{ #category : 'private' }
SimpleTestResourceTestCase >> error [
	'foo' odd

]

{ #category : 'private' }
SimpleTestResourceTestCase >> fail [
	self assert: false

]

{ #category : 'private' }
SimpleTestResourceTestCase >> setRun [
	resource setRun

]

{ #category : 'running' }
SimpleTestResourceTestCase >> setUp [
	"Ensure that we error, not just fail, if resource is nil so that #should:raise: checks cannot mistake such an error for what they are trapping."

	resource := SimpleTestResource rawCurrentForTest.
	self deny: resource == nil
		description: 'SimpleTestResource has no current value in test'.
	self assert: resource class == SimpleTestResource
		description: 'SimpleTestResource current is not an instance of itself'.
	self assert: resource hasSetup
		description: 'This test uses a resource but it was not set up'.

]

{ #category : 'running' }
SimpleTestResourceTestCase >> testDebugTestWithResource [
	"The debug will raise an error if the resource is not set up properly."

	self clearOuterResourceStateDuring:
		[(self class selector: #setRun) debug].

]

{ #category : 'running' }
SimpleTestResourceTestCase >> testResourceCollection [
	self assert: self class buildSuiteFromSelectors resources size = self resources size
		description: 'The suite should have the same number of resources as its test'.
	self class buildSuiteFromSelectors resources do:
		[:each |
		self assert: (self resources includes: each)
			description: each name, ':  I have this resource but my suite does not'].

]

{ #category : 'running' }
SimpleTestResourceTestCase >> testRunSuiteWithResource [
	| suite |
	suite := TestSuite new.
	suite addTest: (SimpleTestResourceTestCase selector: #error).
	suite addTest: (SimpleTestResourceTestCase selector: #fail).
	suite addTest: (self class selector: #dummy).
	self clearOuterResourceStateDuring:
		[self assert: suite run printString = '3 run, 1 passed, 1 failed, 1 error'
			description: 'A suite of tests needing SimpleTestResource did not run as expected'].

]

{ #category : 'running' }
SimpleTestResourceTestCase >> testRunTestWithResource [
	self clearOuterResourceStateDuring:
		[self assert: (self class selector: #dummy) run printString
					= '1 run, 1 passed, 0 failed, 0 errors'
			description: 'A dummy test that needed a resource did not pass'].

]
