Extension { #name : 'ReadByteStreamLegacy' }

{ #category : 'Instance Creation' }
ReadByteStreamLegacy class >> on: aCollection [
  (aCollection _stringCharSize == 0) ifTrue:[
     ArgumentError signal:'expected a String, MultiByteString, or ByteArray'.
  ].
  ^ super on: aCollection
]

{ #category : 'Accessing' }
ReadByteStreamLegacy >> next [
  | pos |
  (itsCollection atOrNil: (pos := position)) ifNotNil:[:res |
     position := pos + 1 .
     ^ res
  ].
  ^ EndOfStream signal
]

{ #category : 'Accessing' }
ReadByteStreamLegacy >> nextOrNil [
 "Returns the next object that the receiver can access for reading.
  Returns nil if an attempt is made to read beyond the end of the stream.
  For use with Streams whose collections do not contain nil .
 "
  | pos |
  (itsCollection atOrNil: (pos := position)) ifNotNil:[:res |
     position := pos + 1 .
     ^ res
  ].
  ^ nil
]

{ #category : 'Accessing' }
ReadByteStreamLegacy >> peek [
"Returns the next element in the collection, but does not alter the current
 position reference.  If the receiver is at the end of the collection, returns
 nil."

 ^ itsCollection atOrNil: position
]

{ #category : 'Accessing' }
ReadByteStreamLegacy >> peek2 [
 "Peeks at the second incoming object."
  ^ itsCollection atOrNil: position + 1 .
]
