Extension { #name : 'Lag25000CmwcRandom' }

{ #category : 'initialization' }
Lag25000CmwcRandom >> initialize [

    "The exact choice of these constants is crucial to obtaining the desired result.
  Refer to literature on the complementary multiply-with-carry algorithm for the
  relationship between the constants.
  Note that the implementation of this class also implies the constant b := 2**32, and none of
  the constants can be changed without changing the others."

	multiplier := 2169967.
	lag := 25000.

]

{ #category : 'public' }
Lag25000CmwcRandom >> integer [
	"Answer a random nonnegative 32-bit integer."

	| newCarryAndSeed newSeed |
	index == nil ifTrue: [self setSeedFromHost].
	newCarryAndSeed := (seeds at: index) * multiplier + carry.
	newSeed := 16rFFFFFFFF - (newCarryAndSeed bitAnd: 16rFFFFFFFF).
	carry := newCarryAndSeed bitShift: -32.
	index == lag ifTrue: [index := 0].
	index := index + 1.
	seeds at: index put: newSeed.
	^newSeed

]

{ #category : 'public' }
Lag25000CmwcRandom >> seed: newSeed [

"Sets the seed from the given SmallInteger.
 Since the seed of this class is much larger than a SmallInteger, we
 use this seed to seed a lag 1 generator, then generate our seeds with that generator."

	self setSeedFromGenerator: (Lag1MwcRandom seed: newSeed).

]

{ #category : 'private' }
Lag25000CmwcRandom >> setSeedFromGenerator: random [

	seeds := Array new: lag.
	1 to: lag do: [:i | seeds at: i put: random integer].
	carry := random integer \\ multiplier.
	index := 1

]

{ #category : 'private' }
Lag25000CmwcRandom >> setSeedFromHost [

	self setSeedFromGenerator: HostRandom new.

]

{ #category : 'private' }
Lag25000CmwcRandom >> validateFullState: fullState [

	| newIndex newCarry seedArray |
	fullState size = 3 ifFalse: [ArgumentError signal: 'expected an Array of size 3'].
	newIndex := fullState at: 1.
	newCarry := fullState at: 2.
	seedArray := fullState at: 3.
	newIndex _isSmallInteger ifFalse: [ArgumentError signal: 'Index must be a SmallInteger'].
	(newIndex between: 1 and: lag) ifFalse:  [OutOfRange new
												name: 'index' min: 1 max: lag actual: newIndex;
															signal: 'out of range'].
	newCarry _isSmallInteger ifFalse: [ArgumentError signal: 'Carry must be a SmallInteger'].
	(newCarry between: 0 and: multiplier - 1) ifFalse: [OutOfRange new
															name: 'carry' min: 0 max: multiplier - 1 actual: newCarry;
															signal: 'out of range'].
	seedArray size = lag ifFalse: [ArgumentError signal: 'Expected seed array of size ' , lag printString].
	seedArray do: [:seed |
					seed _isSmallInteger ifFalse: [ArgumentError signal: 'Each seed must be a SmallInteger'].
					(seed between: 0 and: 16rFFFFFFFF) ifFalse: [OutOfRange new
																		name: 'seed' min: 0 max: 16rFFFFFFFF actual: seed;
																		signal: 'out of range']].

]
