Extension { #name : 'AppendStream' }

{ #category : 'Instance Creation' }
AppendStream class >> new [
   "Disallowed.  To create a new AppendStream, use the class method on: instead."
   self shouldNotImplement: #new

]

{ #category : 'Instance Creation' }
AppendStream class >> on: aCollection [
 ^ self basicNew on: aCollection.

]

{ #category : 'Testing' }
AppendStream >> atEnd [
  ^ self shouldNotImplement: #atEnd
]

{ #category : 'Accessing' }
AppendStream >> collection [
  ^ collection 
]

{ #category : 'Accessing' }
AppendStream >> contents [
  "Returns the contents without making a copy, for efficency."
  | res |
  res := collection .
  collection := res class new .
  ^ res
]

{ #category : 'Character writing' }
AppendStream >> cr [
"Append a return character to the receiver."
  collection addCodePoint: 13 .

]

{ #category : 'Character writing' }
AppendStream >> crlf [
"Append a carriage return character followed by a line feed character to the receiver."

  collection addAll: CrLf .

]

{ #category : 'Character writing' }
AppendStream >> crtab [
  "Append a return character, followed by a single tab character, to the
  receiver."

  collection addAll: CrTab

]

{ #category : 'Character writing' }
AppendStream >> crtab: anInteger [
  "Append a return character, followed by anInteger tab characters, to the
  receiver."

  collection addCodePoint: 13 .
  anInteger timesRepeat: [ collection addCodePoint: 9 ]

]

{ #category : 'Positioning' }
AppendStream >> isEmpty [
  ^ collection size == 0

]

{ #category : 'Character writing' }
AppendStream >> lf [
  "Append a line feed character to the receiver."
  collection addCodePoint: 10


]

{ #category : 'Accessing' }
AppendStream >> next [
  ^ self shouldNotImplement: #next
]

{ #category : 'Adding' }
AppendStream >> nextPut: aCharacter [
  ^ collection add: aCharacter .

]

{ #category : 'Adding' }
AppendStream >> nextPutAll: aString [
  ^ collection addAll: aString

]

{ #category : 'Adding' }
AppendStream >> nextPutAllBytes: aCharacterCollection [

"Adds the byte contents of aCharacterCollection to the receiver ,
 using big-endian byte ordering of aCharacterCollection .
 Returns aCharacterCollection.

 The aCharacterCollection argument must be a kind of String or
 MultiByteString."

"Used in implementation of methods to support PassiveObject."

  ^ collection addAllBytes: aCharacterCollection

]

{ #category : 'Encoding' }
AppendStream >> nextPutAllUtf8: aCharacterOrString [
 "Appends the UTF8 encoding of the argument to receiver.

  The receiver's  collection must be a String or Utf8.
  This method will signal an MessageNotUnderstood  (#addAllUtf8: not understood)
  if collection has been promoted to a MultiByteString as a side effect
  of appending code points above 255. "

 ^ collection addAllUtf8: aCharacterOrString

]

{ #category : 'Adding' }
AppendStream >> nextPutCodePoint: aSmallInteger [

  ^ collection addCodePoint: aSmallInteger

]

{ #category : 'Private' }
AppendStream >> on: aCollection [
  collection := aCollection .

]

{ #category : 'Positioning' }
AppendStream >> position [
  ^ collection size .
]

{ #category : 'Adding' }
AppendStream >> print: anObject [
  anObject printOn: self

]

{ #category : 'Positioning' }
AppendStream >> reset [
  "If collection has been set to nil by a send of #contents ,
   you need to install a new collection with #on:  ."
  collection ifNotNil:[:coll | coll  size: 0 ].
]

{ #category : 'Positioning' }
AppendStream >> size [
  ^ collection size

]

{ #category : 'Character writing' }
AppendStream >> space [
  "Append a space character to the receiver."
  collection addCodePoint: 32 .

]

{ #category : 'Character writing' }
AppendStream >> space: anInteger [
  "Append anInteger space characters to the receiver."

  anInteger timesRepeat: [  collection addCodePoint: 32 ]

]

{ #category : 'Character writing' }
AppendStream >> tab [
  "Append a tab character to the receiver."
  collection addCodePoint: 9  .

]

{ #category : 'Character writing' }
AppendStream >> tab: anInteger [
"Append anInteger tab characters to the receiver."

anInteger timesRepeat: [ collection addCodePoint: 9  ]

]
