"
Upgrade2C is a class used during image upgrade.  
Methods should only be executed via the image upgrade scripts.
"
Class {
	#name : 'Upgrade2C',
	#superclass : 'PrivateObject',
	#category : 'Kernel-Build'
}

{ #category : 'Image Upgrade' }
Upgrade2C class >> _checkMaxSecurityPolicyId [
 "Check number of old objectSecurityPolicies needing conversion"
 | oldRep |
 oldRep := Globals at:#SystemRepository .
 oldRep class superClass == Array ifTrue:[ | oldSize maxSegId |
   oldSize := oldRep size .
   maxSegId := 16rFFFE .
   oldSize <= maxSegId ifTrue:[
      ^ oldSize
   ] ifFalse:[
     Error signal: 'old SystemRepository too big, only the first ' , maxSegId asString ,
	' out of ' , oldSize asString , ' will be converted.'
   ]
 ] ifFalse:[
   ^ 0 "no conversion needed"
 ]

]

{ #category : 'Image Upgrade' }
Upgrade2C class >> _createSegmentAliases [
  "Create aliases for changed names in Globals"
| report list |
report := String new .
list := #(
  #(#'Segment'				#'GsObjectSecurityPolicy')
  #(#'DataCuratorSegment'		#'DataCuratorObjectSecurityPolicy')
  #(#'SystemSegment'			#'SystemObjectSecurityPolicy')
  #(#'SecurityDataSegment'	#'SecurityDataObjectSecurityPolicy')
  #(#'GsIndexingSegment'		#'GsIndexingObjectSecurityPolicy')
  #(#'PublishedSegment'		#'PublishedObjectSecurityPolicy')
   ).
list do: [:pair |
  | oldName newName oldValue newValue |
  oldName := pair at: 1.
  newName := pair at: 2.
  oldValue := Globals at: oldName otherwise: nil.
  newValue := Globals at: newName otherwise: nil.
  (oldValue == nil and:[ newValue ~~ nil]) ifTrue: [
    Globals at: oldName put: newValue.
    report add: 'added '; add: oldName ; lf .
  ].
  (newValue == nil and:[ oldValue ~~ nil]) ifTrue: [
     Globals at: newName put: oldValue.
     report add: 'added '; add: newName ; lf .
  ].
].
list do:[:pair | pair do:[:key | (Globals associationAt: key) immediateInvariant ]].
GsFile gciLogServer: report .

]

{ #category : 'Image Upgrade' }
Upgrade2C class >> _initCharacter [
(Character classVarAt: 'Backspace' otherwise: nil) ifNil:[ | arr |
  arr := {
    #Backspace . Character codePoint: 8  .
    #Lf . Character codePoint: 10 .
    #Cr . Character codePoint: 13 .
    #Esc . Character codePoint: 27 .
    #NewPage . Character codePoint: 12 .
    #Tab . Character codePoint: 9 . }.
  1 to: arr size by: 2 do:[:j |
    Character _addInvariantClassVar: (arr at: j) value: (arr at: j + 1)
  ].
  GsFile gciLogServer:'Character added classVars'.
  ^ 'added'
].
^ 'no change'

]

{ #category : 'Image Upgrade' }
Upgrade2C class >> _initDeletedUsers [
| deletedUserSet |
deletedUserSet := Globals at: #AllDeletedUsers otherwise: nil .
deletedUserSet ifNotNil:[
  GsFile gciLogServer:'AllDeletedUsers already exists' .
  ^ self
].

deletedUserSet := IdentitySet new.
deletedUserSet assignToObjectSecurityPolicyId: AllUsers objectSecurityPolicyId .
Globals at: #AllDeletedUsers put: deletedUserSet .
GsFile gciLogServer: 'Successfully created AllDeletedUsers' .

]

{ #category : 'Image Upgrade' }
Upgrade2C class >> _initDeprecated [
  | assoc |
  Globals at:#DeprecationEnabled ifAbsentPut:[ nil ].  "fix 51520"
  assoc := Globals associationAt: #DeprecationEnabled.
  assoc  objectSecurityPolicy == SystemObjectSecurityPolicy ifTrue:[
     assoc objectSecurityPolicy: DataCuratorObjectSecurityPolicy .
  ].
  ^ true

]

{ #category : 'Image Upgrade' }
Upgrade2C class >> _initGsPackagePolicy [
GsPackagePolicy current.    "create fresh instance in slowfilein"

]

{ #category : 'Image Upgrade' }
Upgrade2C class >> _initIcuCollator [
  IcuCollator _initializeConstants

]

{ #category : 'Image Upgrade' }
Upgrade2C class >> _initNumericConstants [
  | blk |
  "initialize various Maximum... numeric value classvars"
  LargeInteger _initializeMaximumValues .
  blk := [:k :v | | oldVal |  "fix 44807"
    oldVal := Globals at: k otherwise: nil .
    (oldVal class == v class and:[ oldVal asString = v asString ]) ifFalse:[
      Globals at: k put: v
    ] ifTrue:[
      oldVal isInvariant ifFalse:[ oldVal immediateInvariant].
    ]
  ].
  { #PlusInfinity . #MinusInfinity . #PlusQuietNaN .
     #MinusQuietNaN . #PlusSignalingNaN . #MinusSignalingNaN }
   do: [ :aSymbol | | f decf decKey |
      f := Float fromString: aSymbol .
      decf := DecimalFloat fromString: aSymbol .
      decKey := Symbol withAll: 'Decimal' , aSymbol .
      blk value: aSymbol value: f .    "fix 43772, regenerate always"
      blk value: decKey value: decf .
      Float _addInvariantClassVar: aSymbol value: f .
      (Float _classVars at: aSymbol) asString = f asString ifFalse:[
        Error signal: 'bad ', aSymbol .
      ].
      DecimalFloat _addInvariantClassVar: decKey value: decf .
      (DecimalFloat _classVars at: decKey) asString = decf asString ifFalse:[
        Error signal: 'bad ', aSymbol .
      ].
  ].

]

{ #category : 'Image Upgrade' }
Upgrade2C class >> _initSecurityPolicies [
" fix 41803 merged from 2.4.5 ; fix 47441"
 "Now convert or initialize the objectSecurityPolicies in the repository."
|  oldRep inConversion
   rep count report seg sysUser installSegBlock segsCreated |
report := String new .
oldRep := Globals at:#SystemRepository .
oldRep class superClass == Array ifTrue:[ | newSize newRep |
   inConversion := true .
   newSize := oldRep size min: 16rFFFE .  "note message above"
   newSize < 2 ifTrue:[ | dcSeg |
     dcSeg := Globals at:#DataCuratorObjectSecurityPolicy otherwise: nil  .
     dcSeg ~~ nil ifTrue:[
       "looks like a 2.0 or 2.1 repository, need to fixup DataCuratorObjectSecurityPolicy"
       newSize := 2.
       oldRep at:2 put: DataCuratorObjectSecurityPolicy .
       { #GsIndexingObjectSecurityPolicy . #PublishedObjectSecurityPolicy .
	 #GsTimeZoneObjectSecurityPolicy . #SecurityDataObjectSecurityPolicy }
		do:[ :aKey | | aSeg |
          aSeg := Globals at: aKey otherwise: nil .
          aSeg == (oldRep at: 1) ifTrue:[
            "delete this ref to SystemObjectSecurityPolicy"
            Globals removeKey: aKey .
          ].
        ]
     ].
   ].
   newRep := Repository new: newSize .   "new: not yet disallowed"
   newRep instVarAt:1 put: (oldRep instVarAt:1) "name"  .
   newRep instVarAt:2 put: (oldRep instVarAt:2) "dataDictionary" .
   newRep _unsafeSetOop: 240641 .

   GsObjectSecurityPolicy _clearConstraints .

   1 to: newSize do:[:segId| | anObjectSecurityPolicy |
     anObjectSecurityPolicy := oldRep at: segId .
     anObjectSecurityPolicy _unsafeAt: 1 put: newRep .
     anObjectSecurityPolicy _unsafeAt: 7 put: segId  "objectSecurityPolicyId" .
   ].
   1 to: newSize do:[:segId| | anObjectSecurityPolicy |
     anObjectSecurityPolicy := oldRep at: segId .
     newRep _basicAt:segId put: anObjectSecurityPolicy .
     anObjectSecurityPolicy objectSecurityPolicy: DataCuratorObjectSecurityPolicy .
   ].
   newRep objectSecurityPolicy:  DataCuratorObjectSecurityPolicy .
   Globals at:#SystemRepository put: newRep .
   Globals at:#OldSystemRepository put: oldRep .
   report addAll: 'converted ' ; addAll: newSize asString ;
     addAll: ' objectSecurityPolicies. '
] ifFalse:[
   inConversion := false .
   report addAll: 'conversion of SystemRepository not needed. '
].

"Ensure all ObjectSecurityPolicies from a virgin 2.2 exist .
 Gs64 v2.2 bom.c only creates the first 2 . "

rep := Globals at:#SystemRepository .
count := 0 .
segsCreated := { false . false . false . false .  false . false . false . false } .
rep size < 8 ifTrue:[
  [ rep size < 8 ] whileTrue:[
    count := count + 1 .
    GsObjectSecurityPolicy newInRepository: rep .
    segsCreated at: rep size put: true .
  ].
  report addAll:'created '; addAll: count asString ; addAll: ' objectSecurityPolicies. '
].
sysUser := AllUsers userWithId:'SystemUser' .
rep := Globals at:#SystemRepository .

installSegBlock := [ :aKey :aSeg | | oldSeg |
  oldSeg := Globals at: aKey otherwise: nil .
  oldSeg == nil ifTrue:[
    Globals at: aKey put: aSeg
  ] ifFalse:[
    oldSeg == aSeg ifFalse:[
      nil error:'invalid GsObjectSecurityPolicy reference in Globals'
    ]
  ]
].

seg := rep at: 1 .		"repeats bom work, needed for conversion"
installSegBlock value:#SystemObjectSecurityPolicy value: seg .
((segsCreated at: 1) or:[ inConversion]) ifTrue:[
  seg  owner: sysUser ; ownerAuthorization: #write  ;
    worldAuthorization: #read  .
].

seg := rep at: 2 .		"repeats bom work, needed for conversion"
installSegBlock value:#DataCuratorObjectSecurityPolicy value: seg .
((segsCreated at: 2) or:[ inConversion]) ifTrue:[
  seg owner: (AllUsers userWithId:'DataCurator') ;
    ownerAuthorization: #write  ;
    worldAuthorization: #read  .
].

				"remaining not done in bom"
seg := rep at: 3 .	"GsTimeZoneObjectSecurityPolicy no longer used"

seg := rep at: 4 .
installSegBlock value:#GsIndexingObjectSecurityPolicy value: seg .
((segsCreated at: 4) or:[ inConversion]) ifTrue:[
  seg isInvariant ifFalse:[
    seg name: #GsIndexingObjectSecurityPolicy ;
      owner: sysUser ; ownerAuthorization: #write  ;
      worldAuthorization: #write  ; immediateInvariant .
].
].

seg := rep at: 5 .
installSegBlock value:#SecurityDataObjectSecurityPolicy value: seg .
seg isInvariant ifFalse:[
  seg name: #SecurityDataObjectSecurityPolicy ;
    owner: sysUser ; ownerAuthorization: #write  ;
    worldAuthorization: #none  ;  immediateInvariant; _unsafeSetOop: 235777 .
].

seg := rep at: 6 .
installSegBlock value:#PublishedObjectSecurityPolicy value: seg .
((segsCreated at: 6) or:[ inConversion]) ifTrue:[
  seg isInvariant ifFalse:[
    seg owner: sysUser ;   "group authorizations done later in bomlast"
      ownerAuthorization: #write ;
    worldAuthorization: #none .
  ].
].

"GsObjectSecurityPolicy 7 , owned by GcUser , fixed up later"
"GsObjectSecurityPolicy 8, owned by Nameless, fixed up later"

inConversion ifTrue:[
  "converting from a pre-Gs64 v2.2 repository.
   Fix 35966 , repositories from Gs64 v2.0.x and v2.1.x  may
   have objectSecurityPolicyId == OOP_NIL (10r20) in disk object headers ,
   so preallocate a GsObjectSecurityPolicy for objectSecurityPolicyId 20 that is world read-write "
   rep size < 20 ifTrue:[ | newSeg |
     "Possibly a Gs64 v2.0.x or v2.1.x  repository "
     newSeg := GsObjectSecurityPolicy newInRepository: rep .
     newSeg owner: sysUser; ownerAuthorization: #write;
            worldAuthorization:#write ; immediateInvariant  .
     newSeg objectSecurityPolicyId >= 20 ifTrue:[
        nil error:'invalid objectSecurityPolicyId'
     ].
     newSeg _unsafeAt: 7 put: 20 . "_setObjectSecurityPolicyId:  fix 38084"
     rep size: 20 .
     rep at: 20 put: newSeg .
     report addAll: ' created GsObjectSecurityPolicy 20 .'.
   ]
].
GsFile gciLogServer: report

]

{ #category : 'Image Upgrade' }
Upgrade2C class >> _initTraceIr [
 (GsNMethod _classVars associationAt:#TraceIR)
    objectSecurityPolicy: DataCuratorObjectSecurityPolicy  .

]

{ #category : 'Image Upgrade' }
Upgrade2C class >> _installSecurityPolicyNames [
 "install the name for each ObjectSecurityPolicy as a dynamic instVar"
GsFile gciLogServer:'starting _installSecurityPolicyNames'.
SystemObjectSecurityPolicy _name ifNil:[
  | nameBlk upBlk |
  #( #DataCuratorObjectSecurityPolicy
     #GsIndexingObjectSecurityPolicy
     #PublishedObjectSecurityPolicy
     #SecurityDataObjectSecurityPolicy
     #SystemObjectSecurityPolicy
     ) do:[ :aSym |
       (Globals at: aSym otherwise: nil) ifNotNil:[:policy |
          (policy _name == nil and:[ policy isInvariant not]) ifTrue:[
              policy name: aSym asString .
              GsFile gciLogServer: 'named ' , aSym
           ].
       ] ifNil:[ GsFile gciLogServer: ' not found: ' , aSym ].
  ].
  nameBlk := [:id :sym |
   SystemRepository size >= id ifTrue:[
     (SystemRepository at: id) ifNotNil:[:pol |
       (pol _name == nil and:[ pol isInvariant not]) ifTrue:[
          pol name: sym .  GsFile gciLogServer:'named ' , id asString, ' as ', sym].
      ].
    ].
  ].
  upBlk := [:id :uid :sym | |up |
    up := AllUsers userWithId: uid ifAbsent:[nil] .
    up ifNotNil:[ (SystemRepository at: id) == up defaultObjectSecurityPolicy
                       ifTrue:[ nameBlk value: id value: sym ]].
  ].
  nameBlk value: 3 value: #GsTimeZoneObjectSecurityPolicy . "policy no longer used"

  upBlk value: 7 value: 'GcUser' value: #GcUserObjectSecurityPolicy .
  upBlk value: 8 value: 'Nameless' value: #NamelessObjectSecurityPolicy .
  GsFile gciLogServer:'added names'.
  ^ self
].
GsFile gciLogServer:'no change'

]

{ #category : 'Image Upgrade' }
Upgrade2C class >> _patchSecurityPolicy15 [
"Patch SystemRepository for mismatched policyId seen in some 3.3.x repositories, fix 48089"
| newPol oldPol newPolId |
SystemRepository size >= 15 ifTrue:[
  (oldPol := SystemRepository at: 15) objectSecurityPolicyId == 20 ifTrue:[
    newPol := GsObjectSecurityPolicy new .
    newPolId := newPol objectSecurityPolicyId .
    1 to: GsObjectSecurityPolicy instSize do:[:n|
      newPol _unsafeAt: n put:(oldPol instVarAt: n) "copy state of policy 15"
    ].
    newPol _unsafeAt: 7 put: 15 . "set itsId instVar"
    SystemRepository _at: 15 put: newPol .
    SystemRepository _at: newPolId put: nil .
    GsFile gciLogServer: 'Recreated GsObjectSecurityPolicy 15'.
    ^ self
  ].
  GsFile gciLogServer: 'No changes to GsObjectSecurityPolicy 15'.
]
]

{ #category : 'Image Upgrade' }
Upgrade2C class >> _removeGsTestResult362 [
	"If the version of GsTestResult from 3.6.2 is present, remove
	it to avoid creating a new class version during upgrade."

	| verDict release |
	verDict := Globals at: #'ImageVersion' ifAbsent: [ ^ self ].
	verDict ifNil: [ ^ self ].
	release := verDict at: #'gsRelease' ifAbsent: [ ^ self ].
	(release findString: '3.6.2' startingAt: 1) = 1
		ifFalse: [ ^ self ].
	Globals removeKey: #'GsTestResult' ifAbsent: [ ^ self ].
	GsFile gciLogServer: 'removed GsTestResult'
]

{ #category : 'Image Upgrade' }
Upgrade2C class >> _removePrivateClassesFromGlobals [
| str aClass |
str := String new .
{ 211969  "NscNode".
  212225  "NscInteriorNode".
  212481  "NscSetLeaf".
  212737  "NscBagLeaf".
  209409  "LargeObjectNode".
  245761  "Large2ByteLeaf".
  246017  "Large4ByteLeaf".
  246273  "Large8ByteLeaf" } do:[:anOop | | cls key |
    cls := Object _objectForOop: anOop .
    cls removeAllMethods .
    cls class removeAllMethods .
    (Globals includesKey: (key := cls name)) ifTrue:[
      " remove Associations of private classes from Globals"
      Globals removeKey: key .
      str add: 'removed ' , key ; lf .
    ]
].
GsFile gciLogServer: str .
aClass := Object _objectForOop: 211969  "NscNode" .
aClass compileMethod:'size  ^ _varyingSize . "for better output from topaz DUMPOBJ" '.

]

{ #category : 'Image Upgrade' }
Upgrade2C class >> _setMiscSecurityPolicies [

(SystemLoginNotification _classVars associationAt: #Subscriptions) objectSecurityPolicy: nil.
(TransactionBoundaryDefaultPolicy _classVars associationAt: #Current) objectSecurityPolicy: nil.

]

{ #category : 'Image Upgrade' }
Upgrade2C class >> initialize [
  GsSocket _initSocketErrorSymbols .
  AppendStream initialize .
  self
    _removePrivateClassesFromGlobals ;
    _removeGsTestResult362;
    _checkMaxSecurityPolicyId ;
    _initSecurityPolicies ;
    _createSegmentAliases ;
    _installSecurityPolicyNames ;
    _patchSecurityPolicy15 ;
    _setMiscSecurityPolicies ;
    _initGsPackagePolicy ;
    _initNumericConstants ;
    _initTraceIr .
  System commit.
  self
    _initIcuCollator ;
    _initDeletedUsers ;
    _initCharacter ;
    _initDeprecated .
  GsBitmap _initializeSystemHiddenSetIds .
  System commit.
  ^ true
]
