"
TestCase is an abstract superclass for classes that implement specific tests. 

Each method of a TestCase subclass with a selector name that starts with 'test' acts an 
executable test, and will be run. When you create a subclass of TestCase, the framework 
automatically builds a test suite from the test methods of your subclass.

The set of tests that is run will include tests on this class and tests inherited from 
superclasses. To control which tests are run in a hierarchy under TestCase, implement the 
class method isAbstract and/or #shouldInheritSelectors on the superclasses. 

The methods setUp and tearDown are always executed before and after the execution of 
a test method. You can use them to set a specific context in which your test methods are 
executed; e.g., add instance variables to your subclass, and implement setUp and tearDown 
for your subclass to initialize and release values. 

For example, create a subclass of TestCase (for example MyTestCaseSubclass), and implement 
a test method:
test_mytest
   self assert: ( true ).
   self assert:  1 + 1 equals: 2.
   self deny: ( nil notNil ).
   self should: [ 1 / 0 ] raise: 2026.

To run all or a single test and report tests failed, errored, and passed, execute:  
  MyTestCaseSubclass run  
  MyTestCaseSubclass run: #test_mytest

Failures are test assertions that were not met, while errors are code failures such as 
message not understood. 

To run all or a single test, and stop on the first error or failure:
  MyTestCaseSubclass debug
  MyTestCaseSubclass debug: #test_mytest

Example test cases in the image are ExampleSetTest, SUnitTest, SimpleTestResourceTestCase 
and its subclasses and ResumableTestFailureTestCase.

This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz
"
Class {
	#name : 'TestCase',
	#superclass : 'TestAsserter',
	#instVars : [
		'testSelector'
	],
	#category : 'SUnit-Kernel'
}
