"
Lag1MwcRandom is a seedable random number generator with a period of about 10**18.

See also the class comments of Random and SeededRandom.

Lag1MwcRandom is a lag-1 generator using the multiply-with-carry algorithm to generate random 
numbers. Compared to Lag25000CmwcRandom, its period is much shorter, it is of limited 
use in generating random n-tuples, and it has been shown that the random bits of the MWC algorithm 
are not quite perfectly fair, so for some uses Lag25000CmwcRandom is superior to this class. 
The primary advantage of Lag1MwcRandom is that it can be seeded by a single 61-bit SmallInteger, 
and initialized quickly, whereas Lag25000CmwcRandom requires a seed of more than 800000 bits, 
and therefore takes considerably longer to initialize, though it's faster once initialized.

Lag25000CmwcRandom>>seed: uses a Lag1MwcRandom to generate all the seed bits from the 
given SmallInteger seed. 
"
Class {
	#name : 'Lag1MwcRandom',
	#superclass : 'SeededRandom',
	#category : 'NumberGenerators'
}
