"
HostRandom allows access to the host operating system's /dev/urandom random number 
generator.

See also the class comment of Random.

HostRandom is fairly fast to initialize, but after initialization is considerably slower 
than the other subclasses of Random. However, /dev/urandom 
on some platforms may be intended to be a cryptographically secure random number 
generator, which none of the other subclasses are. It also has the advantage of 
not needing an initial seed, and so is good for generating random seeds for the 
faster Random subclasses.

HostRandom uses a shared singleton instance, which is accessed by sending #new to 
the class HostRandom. Sending #new has the side effect of opening the underlying file 
/dev/urandom. This file normally remains open for the life of the session, but if 
you wish to close it you can send #close to the instance, and later send #open to 
reopen it. If you store a persistent reference to the singleton instance the underlying
file will not be open in a new session and you must send #open to the instance before 
asking for a random number. Since the singleton HostRandom instance has no state, 
it may be shared by multiple sessions without conflict.

Since HostRandom is a service from the operating system, it cannot be seeded, and 
should not be used when a repeatable random sequence of numbers is needed.
"
Class {
	#name : 'HostRandom',
	#superclass : 'Random',
	#classInstVars : [
		'singleton'
	],
	#category : 'NumberGenerators'
}
