"
AppendStream is a replacement for WriteStream, for streams that are are 
created empty,  appended to , and then the contents are retrieved.
There is no stream-specific support for reading, write limit, nor 
position logic.  Because position and write limit are not
supported the nextPut methods are faster than in WriteStream.
"
Class {
	#name : 'AppendStream',
	#superclass : 'Stream',
	#instVars : [
		'collection'
	],
	#classVars : [
		'CrLf',
		'CrTab'
	],
	#category : 'Collections-Streams'
}

{ #category : 'Image Upgrade' }
AppendStream class >> initialize [
(AppendStream classVarAt: #CrLf otherwise: nil) ifNil:[ | arr |
  arr := {
    #CrLf .  (String new add:(Character codePoint: 13);
                 add: (Character codePoint: 10); immediateInvariant
                ; yourself ) .
    #CrTab .  (String new add:(Character codePoint: 13);
                 add: (Character codePoint: 9); immediateInvariant
                ; yourself )
  }.
  1 to: arr size by: 2 do:[:j |
    AppendStream _addInvariantClassVar: (arr at: j) value: (arr at: j + 1)
  ].
  GsFile gciLogServer:'AppendStream added classVars' .
  ^ 'added'
].
^ 'no change'

]
