"
Upgrade2A is a class used during image upgrade.  
Methods should only be executed via the image upgrade scripts.
"
Class {
	#name : 'Upgrade2A',
	#superclass : 'PrivateObject',
	#category : 'Kernel-Build'
}

{ #category : 'Image Upgrade' }
Upgrade2A class >> initialize [
  "Create classes in GemStone_Portable_Streams.
   Note the classes in GemStone_Legacy_Streams were created in bom.c"
  | blk |
blk := [:aClass |
 aClass _category: 'Collections-Streams' .
 GsFile gciLogServer: 'created ', aClass name,'  oop ', aClass asOop asString ,
   ' superclass ' , aClass superclass asOop asString 
  ].
blk value:(
Stream
  subclass: 'PositionableStream'
  instVarNames: #( collection position readLimit )
  inDictionary: GemStone_Portable_Streams  ).
blk value:(
(GemStone_Portable_Streams at: #PositionableStream)
  subclass: 'ReadStream'
  instVarNames: #(  )
  inDictionary: GemStone_Portable_Streams ).
blk value:(
(GemStone_Portable_Streams at: #PositionableStream)
  subclass: 'WriteStream'
  instVarNames: #( writeLimit )
  classVars: #( Cr CrLf CrTab )
  classInstVars: #(  )
  poolDictionaries: #()
  inDictionary: GemStone_Portable_Streams
  options: #() ) .
blk value:(
(GemStone_Portable_Streams at: #WriteStream)
  subclass: 'ReadWriteStream'
  instVarNames: #(  )
  inDictionary: GemStone_Portable_Streams ).
blk value:(
(GemStone_Portable_Streams at: #ReadWriteStream)
  subclass: 'FileStream'
  instVarNames: #( gsfile streamType )
  inDictionary: GemStone_Portable_Streams ).

blk value:(
(GemStone_Portable_Streams at: #ReadStream)
  subclass: 'ReadByteStream'
  instVarNames: #(  )
  inDictionary: GemStone_Portable_Streams ).
blk value:(
(GemStone_Legacy_Streams at: #ReadStream)
  subclass: 'ReadByteStream'
  instVarNames: #(  )
  inDictionary: GemStone_Legacy_Streams ).

(Globals associationAt:#GsFileIn otherwise:nil) ifNotNil:[:assoc |
   assoc value instSize < 17 ifTrue:[
     | cls |
     cls := assoc value.
     cls _unsafeAt: 11 put: #ObsoleteGsFileIn.
     GsFile gciLogServer:'GsFileIn renamed to ObsoleteGsFileIn'.
     Globals removeAssociation: assoc .
     assoc key: cls name.
     ObsoleteClasses addAssociation: assoc .
     GsFile gciLogServer:'ObsoleteGsFileIn moved to ObsoleteClasses'.
     ].
  ].
^ true
]
