Class {
	#name : 'TransactionBoundaryDefaultPolicy',
	#superclass : 'Object',
	#classVars : [
		'Current'
	],
	#category : 'SessionMethodsSupport'
}

{ #category : 'accessing' }
TransactionBoundaryDefaultPolicy class >> current [

	Current == nil ifTrue: [ Current := self basicNew initialize ].
	^Current

]

{ #category : 'installation' }
TransactionBoundaryDefaultPolicy class >> install [

    Current := nil.
    ^self installCurrent

]

{ #category : 'installation' }
TransactionBoundaryDefaultPolicy class >> installCurrent [

    System _commitCoordinator: self current.
    ^self current

]

{ #category : 'testing' }
TransactionBoundaryDefaultPolicy class >> isActive [

    ^(Current ~~ nil) and: [Current isActive]

]

{ #category : 'installation' }
TransactionBoundaryDefaultPolicy class >> uninstall [

    Current := nil.

]

{ #category : 'commit coordinator' }
TransactionBoundaryDefaultPolicy >> abort [
    | res |
    res := System _localAbort.
    self transactionBoundary: #abort.
    ^res

]

{ #category : 'commit coordinator' }
TransactionBoundaryDefaultPolicy >> beginTransaction [
    | res |
    res := System _localBeginTransaction.
    self transactionBoundary: #beginTransaction.
    ^res

]

{ #category : 'updating' }
TransactionBoundaryDefaultPolicy >> classChanged [
	"by default do nothing"

]

{ #category : 'commit coordinator' }
TransactionBoundaryDefaultPolicy >> commit: commitMode [
    | res |
    (res := System _localCommit: commitMode)
        ifTrue: [ self transactionBoundary: #commit ].
    ^res

]

{ #category : 'initialization' }
TransactionBoundaryDefaultPolicy >> initialize [
	"by default do nothing"

]

{ #category : 'testing' }
TransactionBoundaryDefaultPolicy >> isActive [

    ^true

]

{ #category : 'updating' }
TransactionBoundaryDefaultPolicy >> sessionMethodChanged [
	"by default do nothing"

]

{ #category : 'private-actions' }
TransactionBoundaryDefaultPolicy >> transactionBoundary: transactionSymbol [
	"by default do nothing"

]

{ #category : 'commit coordinator' }
TransactionBoundaryDefaultPolicy >> transactionMode: newMode [
    | res |
    res := System _localTransactionMode: newMode.
    self transactionBoundary: #transactionMode.
    ^res

]
