Extension { #name : 'SmallDouble' }

{ #category : 'Storing and Loading' }
SmallDouble class >> loadFrom: passiveObj [

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| inst |

inst := self fromStringLocaleC:  passiveObj upToSeparator .
"no hasRead: here, since SmallDouble is a special"
^inst

]

{ #category : 'Private' }
SmallDouble >> _asFloat [

"Returns an instance of Float equal to the receiver.
 For use in activation of a PassiveObject and for testing the image.
 It is a performance and space degradation to use this in applications."

^ self _mathPrim: 10

]

{ #category : 'Converting' }
SmallDouble >> _generality [

"Returns the integer that represents the ordering of the receiver in the
 generality hierarchy."

"Reimplemented from Number"

^ 85

]

{ #category : 'Storing and Loading' }
SmallDouble >> containsIdentity [

"Private."

^true

]

{ #category : 'Copying' }
SmallDouble >> copy [
  ^ self

]

{ #category : 'Testing' }
SmallDouble >> isSpecial [

"Returns true if the receiver is a special object."

^ true

]

{ #category : 'Repository Conversion' }
SmallDouble >> needsFixingAfterConversion [
 ^ false

]
