"
RcCounterElement implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

"
Class {
	#name : 'RcCounterElement',
	#superclass : 'Object',
	#instVars : [
		'value'
	],
	#gs_reservedoop : '108289',
	#category : 'NumberGenerators'
}

{ #category : 'Instance Creation' }
RcCounterElement class >> new [

"Creates and returns a new instance of the receiver."

^ self basicNew initialize

]

{ #category : 'Updating' }
RcCounterElement >> decrementValueBy: aNumber [

"Decrement the current value by the given amount."

value := value - aNumber

]

{ #category : 'Updating' }
RcCounterElement >> incrementValueBy: aNumber [

"Increments the current value by the given amount."

value := value + aNumber

]

{ #category : 'Initialization' }
RcCounterElement >> initialize [

"Initializes the value to be zero."

self value: 0

]

{ #category : 'Accessing' }
RcCounterElement >> value [

"Returns the value of the instance variable 'value'."

^ value

]

{ #category : 'Updating' }
RcCounterElement >> value: newValue [

"Modifies the value of the instance variable 'value'."

value := newValue

]
