"
NscBuilder should only be used for transient objects.  They are not
completely logged by the transaction logging subsystem!

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	nsc: IdentityBag
	counter: SmallInteger
	finalResult: UnorderedCollection
"
Class {
	#name : 'NscBuilder',
	#superclass : 'Array',
	#instVars : [
		'nsc',
		'counter',
		'finalResult'
	],
	#gs_options : [
		'subclassesDisallowed'
	],
	#gs_reservedoop : '107777',
	#category : 'Indexing-Internals'
}

{ #category : 'Indexing Support' }
NscBuilder class >> _canCreateQueryOnInstances [
  "Cannot create a GsQuery on the receiver"

  ^ false

]

{ #category : 'Instance Creation' }
NscBuilder class >> for: aBag max: aSize [

"Create an initialized instance of the receiver."

| res |
res := super new: (self maxSize min: aSize).
res counter: 0 ; finalResult: aBag .
(aBag isKindOf: IdentityBag)
  ifTrue:[ res nsc: aBag ]
  ifFalse:[ res nsc: IdentityBag new "handle equality Bag, Set" ].
^ res

]

{ #category : 'Constants' }
NscBuilder class >> maxSize [

"Returns the maximum size of the root object for efficient implementation."

^ 2000

]

{ #category : 'Instance Creation' }
NscBuilder class >> new [

"Create a NscBuilder with the 'for:' message."

self shouldNotImplement: #new

]

{ #category : 'Adding' }
NscBuilder >> _addAll: aCollection [

"Adds all of the elements of aCollection to the receiver.  If aCollection is
 an Array or a subclass of IdentityBag, then the elements of the collection are
 added without faulting them in, otherwise the elements are added individually."

<primitive: 58>
(self == aCollection) ifTrue: [ ^ self addAll: (aCollection copy) ].
aCollection _validateClass: Collection.
aCollection accompaniedBy: self do: [:me :each | me add: each].
^ aCollection

]

{ #category : 'Adding' }
NscBuilder >> _addAllNsc: aBag [

"Adds all of the elements of aBag to the receiver and returns the receiver."

^ self _addAll: aBag

]

{ #category : 'Accessing' }
NscBuilder >> _completeNsc [

"Returns the NSC with all elements of the receiver added to it."

<primitive: 163>
self _primitiveFailed: #completeNsc .
self _uncontinuableError

]

{ #category : 'Updating' }
NscBuilder >> _resetForAudit [

self counter: 0.
nsc removeAll: nsc.
(nsc ~~ finalResult)
  ifTrue: [ finalResult removeAll: finalResult ].

]

{ #category : 'Adding' }
NscBuilder >> add: anObject [

"Add the object to the receiver.  If the receiver is full, add all of
 its contents to the NSC and reset the counter."

<primitive: 326>
self _primitiveFailed: #add: args: { anObject } .
self _uncontinuableError

]

{ #category : 'Adding' }
NscBuilder >> addAll: aCollection [

"Adds all of the elements of aCollection to the receiver and returns the
 receiver."

(self == aCollection)
    ifTrue: [ ^ self addAll: aCollection copy ].
self _addAll: aCollection.
^ self

]

{ #category : 'Adding' }
NscBuilder >> addLast: newObject [

""

self shouldNotImplement: #addLast:

]

{ #category : 'Updating' }
NscBuilder >> at: anIndex put: aValue [

""

self shouldNotImplement: #at:put:

]

{ #category : 'Accessing' }
NscBuilder >> completeBag [

"Returns the complete result object."

| nscRes finalRes |
nscRes := self _completeNsc .
nscRes == finalResult ifFalse:[
  "handle equality Bag, Set"
  finalRes := finalResult .
  1 to: nscRes size do:[ :j | finalRes add: (nscRes _at: j) ] .
				"deleted   'reduce garbage' code"
  ^ finalRes .
  ].
^ nscRes

]

{ #category : 'Updating' }
NscBuilder >> counter: newValue [

"Modify the value of the instance variable 'counter'."

counter := newValue

]

{ #category : 'Updating' }
NscBuilder >> finalResult: newValue [

"Modify the value of the instance variable 'finalResult'."

finalResult := newValue

]

{ #category : 'Updating' }
NscBuilder >> first: obj [

""

self shouldNotImplement: #first:

]

{ #category : 'Adding' }
NscBuilder >> insertAll: aSequenceableCollection at: anIndex [

""

self shouldNotImplement: #insertAll:at:

]

{ #category : 'Updating' }
NscBuilder >> last: obj [

""

self shouldNotImplement: #last:

]

{ #category : 'Updating' }
NscBuilder >> nsc: newValue [

"Modify the value of the instance variable 'nsc'."

nsc := newValue

]

{ #category : 'Removing' }
NscBuilder >> removeFrom: startIndex to: stopIndex [

""

self shouldNotImplement: #removeFrom:to:

]

{ #category : 'Updating' }
NscBuilder >> size: anInteger [

""

self shouldNotImplement: #size:

]
