"
 The Locale class provides access to the host operating system Locale 
 environment (see ""man -s 5 locale"" for details).

 The current Locale is setup in System sessionState field 16, using the
 internal method System(class)>>_locale.  Applications should access this
 object using the method Locale(class)>>current, rather than calling
 System(class)>>_locale directly.

 The various fields in the Locale object match those available in the
 C structure lconv after a localeconv() call (see ""man localeconv"" for 
 details).

 As a convenience, class-side methods allow access to the various fields
 of the current Locale object.  For example:

      Locale decimalPoint

 is the same as:

      Locale current decimalPoint

"
Class {
	#name : 'Locale',
	#superclass : 'Object',
	#instVars : [
		'decimalPoint',
		'thousandsSep',
		'grouping',
		'intCurrSymbol',
		'currencySymbol',
		'monDecimalPoint',
		'monThousandsSep',
		'monGrouping',
		'positiveSign',
		'negativeSign',
		'intFracDigits',
		'fracDigits',
		'pCsPrecedes',
		'pSepBySpace',
		'nCsPrecedes',
		'nSepBySpace',
		'pSignPosn',
		'nSignPosn'
	],
	#gs_reservedoop : '124161',
	#category : 'System-Localization'
}

{ #category : 'Accessing' }
Locale class >> currencySymbol [

   "Return appropriate instvar from the current Locale instance"
   ^self current currencySymbol

]

{ #category : 'Accessing' }
Locale class >> current [

"Get the current Locale instance from session transient state.
  If we dont have one, go ahead and initialize one "

| locale systm |
systm := System .
( locale := systm __sessionStateAt: 16 ) == nil ifTrue: [
    locale := systm _locale.
    systm __sessionStateAt: 16 put: locale ].
^ locale

]

{ #category : 'Accessing' }
Locale class >> decimalPoint [

   "Return appropriate instvar from the current Locale instance"
   ^self current decimalPoint

]

{ #category : 'Accessing' }
Locale class >> fracDigits [

   "Return appropriate instvar from the current Locale instance"
   ^self current fracDigits

]

{ #category : 'Accessing' }
Locale class >> grouping [

   "Return appropriate instvar from the current Locale instance"
   ^self current grouping

]

{ #category : 'Accessing' }
Locale class >> intCurrSymbol [

   "Return appropriate instvar from the current Locale instance"
   ^self current intCurrSymbol

]

{ #category : 'Accessing' }
Locale class >> intFracDigits [

   "Return appropriate instvar from the current Locale instance"
   ^self current intFracDigits

]

{ #category : 'Accessing' }
Locale class >> monDecimalPoint [

   "Return appropriate instvar from the current Locale instance"
   ^self current monDecimalPoint

]

{ #category : 'Accessing' }
Locale class >> monGrouping [

   "Return appropriate instvar from the current Locale instance"
   ^self current monGrouping

]

{ #category : 'Accessing' }
Locale class >> monThousandsSep [

   "Return appropriate instvar from the current Locale instance"
   ^self current monThousandsSep

]

{ #category : 'Accessing' }
Locale class >> nCsPrecedes [

   "Return appropriate instvar from the current Locale instance"
   ^self current nCsPrecedes

]

{ #category : 'Accessing' }
Locale class >> negativeSign [

   "Return appropriate instvar from the current Locale instance"
   ^self current negativeSign

]

{ #category : 'Instance Creation' }
Locale class >> new [

" Use Locale>>current instead "

self shouldNotImplement: #new

]

{ #category : 'Accessing' }
Locale class >> nSepBySpace [

   "Return appropriate instvar from the current Locale instance"
   ^self current nSepBySpace

]

{ #category : 'Accessing' }
Locale class >> nSignPosn [

   "Return appropriate instvar from the current Locale instance"
   ^self current nSignPosn

]

{ #category : 'Accessing' }
Locale class >> pCsPrecedes [

   "Return appropriate instvar from the current Locale instance"
   ^self current pCsPrecedes

]

{ #category : 'Accessing' }
Locale class >> positiveSign [

   "Return appropriate instvar from the current Locale instance"
   ^self current positiveSign

]

{ #category : 'Accessing' }
Locale class >> pSepBySpace [

   "Return appropriate instvar from the current Locale instance"
   ^self current pSepBySpace

]

{ #category : 'Accessing' }
Locale class >> pSignPosn [

   "Return appropriate instvar from the current Locale instance"
   ^self current pSignPosn

]

{ #category : 'Updating' }
Locale class >> setCategory: categorySymbol locale: LocaleString [

   " Modify OS locale setting.

   See man page for setlocale( ) for more details.

   Valid categories:

      #LC_CTYPE        locale's character type handling
      #LC_NUMERIC      locale's decimal handling
      #LC_TIME         locale's time handling
      #LC_COLLATE      locale's collation data
      #LC_MONETARY     locale's monetary handling
      #LC_MESSAGES     locale's messages handling
      #LC_ALL          all locale categories
   "

   | locale |
   " call the setLocale primitive "
   ( System _setCategory: categorySymbol locale: LocaleString ) ifNil: [ ^ nil ].
   " Now reset the transient locale info "
    locale := System _locale.
    System __sessionStateAt: 16 put: locale.
   ^ locale

]

{ #category : 'Accessing' }
Locale class >> thousandsSep [

   "Return appropriate instvar from the current Locale instance"
   ^self current thousandsSep

]

{ #category : 'Accessing' }
Locale >> currencySymbol [

   "Return the value of the instance variable 'currencySymbol'."
   ^currencySymbol

]

{ #category : 'Accessing' }
Locale >> decimalPoint [

   "Return the value of the instance variable 'decimalPoint'."
   ^decimalPoint

]

{ #category : 'Accessing' }
Locale >> fracDigits [

   "Return the value of the instance variable 'fracDigits'."
   ^fracDigits

]

{ #category : 'Accessing' }
Locale >> grouping [

   "Return the value of the instance variable 'grouping'."
   ^grouping

]

{ #category : 'Accessing' }
Locale >> intCurrSymbol [

   "Return the value of the instance variable 'intCurrSymbol'."
   ^intCurrSymbol

]

{ #category : 'Accessing' }
Locale >> intFracDigits [

   "Return the value of the instance variable 'intFracDigits'."
   ^intFracDigits

]

{ #category : 'Accessing' }
Locale >> monDecimalPoint [

   "Return the value of the instance variable 'monDecimalPoint'."
   ^monDecimalPoint

]

{ #category : 'Accessing' }
Locale >> monGrouping [

   "Return the value of the instance variable 'monGrouping'."
   ^monGrouping

]

{ #category : 'Accessing' }
Locale >> monThousandsSep [

   "Return the value of the instance variable 'monThousandsSep'."
   ^monThousandsSep

]

{ #category : 'Accessing' }
Locale >> name [
  ^ self dynamicInstVarAt: #name
]

{ #category : 'Accessing' }
Locale >> nCsPrecedes [

   "Return the value of the instance variable 'nCsPrecedes'."
   ^nCsPrecedes

]

{ #category : 'Accessing' }
Locale >> negativeSign [

   "Return the value of the instance variable 'negativeSign'."
   ^negativeSign

]

{ #category : 'Accessing' }
Locale >> nSepBySpace [

   "Return the value of the instance variable 'nSepBySpace'."
   ^nSepBySpace

]

{ #category : 'Accessing' }
Locale >> nSignPosn [

   "Return the value of the instance variable 'nSignPosn'."
   ^nSignPosn

]

{ #category : 'Accessing' }
Locale >> pCsPrecedes [

   "Return the value of the instance variable 'pCsPrecedes'."
   ^pCsPrecedes

]

{ #category : 'Accessing' }
Locale >> positiveSign [

   "Return the value of the instance variable 'positiveSign'."
   ^positiveSign

]

{ #category : 'Accessing' }
Locale >> pSepBySpace [

   "Return the value of the instance variable 'pSepBySpace'."
   ^pSepBySpace

]

{ #category : 'Accessing' }
Locale >> pSignPosn [

   "Return the value of the instance variable 'pSignPosn'."
   ^pSignPosn

]

{ #category : 'Accessing' }
Locale >> thousandsSep [

   "Return the value of the instance variable 'thousandsSep'."
   ^thousandsSep

]
