"
GsPipeElement describes an individual entry in a GsPipe.

--- instVars
  next    - references the next element in the list for this pipe
  value   - references the value of this element

"
Class {
	#name : 'GsPipeElement',
	#superclass : 'Object',
	#instVars : [
		'next',
		'value'
	],
	#category : 'Collections-IOOrdered'
}

{ #category : 'Instance Creation' }
GsPipeElement class >> newWithNext: nextElement value: aValue [

"Returns a new GsPipeElement instance with the nextElement and aValue"

| element |
element := super new next: nextElement.
element value: aValue.
^element

]

{ #category : 'Reduced Conflict Support' }
GsPipeElement >> _abortAndReplay: conflictObjects [

"Abort the receiver, no replay necessary."

" refresh the state of the receiver "
self _selectiveAbort.

^ true

]

{ #category : 'Accessing' }
GsPipeElement >> next [

"Returns the current value of the next instance variable"
^ next

]

{ #category : 'Updating' }
GsPipeElement >> next: anElement [

next := anElement

]

{ #category : 'Accessing' }
GsPipeElement >> value [

"Returns the current value of the GsPipeElement"
^ value

]

{ #category : 'Updating' }
GsPipeElement >> value: anObj [

value := anObj

]
