"
GsInterSessionSignal is Deprecated.  See InterSessionSignal .

A GsInterSessionSignal represents a signal from one session to another within
 a single GemStone system.

Constraints:
	sessionSerialNum: SmallInteger
	signal: SmallInteger
	message: String

--- instVar message
A String representing application-defined information from the sending
 session.

--- instVar sessionSerialNum
A SmallInteger identifier of the session from which the instance was received.
 To obtain the corresponding session, use the method
 GsSession >> sessionWithSerialNumber:.

--- instVar signal
A SmallInteger representing application-defined information from the sending
 session.

"
Class {
	#name : 'GsInterSessionSignal',
	#superclass : 'Object',
	#instVars : [
		'sessionSerialNum',
		'signal',
		'message'
	],
	#gs_reservedoop : '104961',
	#category : 'System-SessionModel'
}

{ #category : 'Instance Creation' }
GsInterSessionSignal class >> signal: aSignal message: aString [

"Returns a new instance with the given information installed.
 The originating GsSession is set to nil."

| result |
result := super new.
result signal: aSignal; message: aString.
^ result

]

{ #category : 'Accessing' }
GsInterSessionSignal >> message [

"Returns the String sent as a message."

^ message

]

{ #category : 'Accessing' }
GsInterSessionSignal >> message: aString [

"Sets the String to be sent as a message."

message := aString asString


]

{ #category : 'Signalling' }
GsInterSessionSignal >> replyToSenderWithSignal: aSmallInteger withString: aString [

"Sends a signal containing the arguments to the originating session of the
 receiver.  If the session instance variable of the receiver is nil, raises an
 error."

System _sendSignal: aSmallInteger toSess: sessionSerialNum
	withMessage: aString

]

{ #category : 'Signalling' }
GsInterSessionSignal >> sendToSession: aGsSession [

"Sends a signal to the session represented by aGsSession.  The signal contains
 the signal and message instance variables of the receiver.  Ignores the session
 instance variable of the receiver."

aGsSession sendSignalObject: self

]

{ #category : 'Accessing' }
GsInterSessionSignal >> session [

"Returns a transient GsSession object representing the session that sent the
 signal, or nil if there was no signal.  This object can be used as target of
 signals sent in response."

^ GsSession sessionWithSerialNumber: sessionSerialNum

]

{ #category : 'Accessing' }
GsInterSessionSignal >> session: aGsSession [

"Sets the session instance variable so that it represents the session that sent
 the signal."

sessionSerialNum := aGsSession sessionSerialNum

]

{ #category : 'Accessing' }
GsInterSessionSignal >> signal [

"Returns the SmallInteger sent as a signal."

^ signal

]

{ #category : 'Accessing' }
GsInterSessionSignal >> signal: aSmallInteger [

"Sets the SmallInteger to be sent as a signal."

signal := aSmallInteger

]
