Extension { #name : 'GsFileStat' }

{ #category : 'Instance Creation' }
GsFileStat class >> new [

"Disallowed.
  see instance methods in GsFile for methods returning instances of GsFileStat"

  self shouldNotImplement: #new

]

{ #category : 'Accessing' }
GsFileStat >> atimeUtcSeconds [
^  atime

]

{ #category : 'Accessing' }
GsFileStat >> blksize [
^ blksize

]

{ #category : 'Accessing' }
GsFileStat >> blocks [
^  blocks

]

{ #category : 'Accessing' }
GsFileStat >> ctimeUtcSeconds [
^  ctime

]

{ #category : 'Accessing' }
GsFileStat >> dev [
^  dev

]

{ #category : 'Accessing' }
GsFileStat >> gid [
^  gid

]

{ #category : 'Accessing' }
GsFileStat >> ino [
^  ino

]

{ #category : 'Accessing' }
GsFileStat >> isDirectory [
 "Returns true if the receiver describes a directory."
  ^ ( mode bitAnd: 8r170000 "posix S_IFMT") == 8r40000 "posix S_IFDIR"

]

{ #category : 'Accessing' }
GsFileStat >> mode [
^  mode

]

{ #category : 'Accessing' }
GsFileStat >> mtimeUtcSeconds [
^  mtime

]

{ #category : 'Accessing' }
GsFileStat >> nlink [
^  nlink

]

{ #category : 'Accessing' }
GsFileStat >> rdev [
^  rdev

]

{ #category : 'Accessing' }
GsFileStat >> size [
^  size

]

{ #category : 'Accessing' }
GsFileStat >> uid [
^  uid

]
