Extension { #name : 'CompileError' }

{ #category : 'Accessing' }
CompileError >> buildMessageText [
  | str |
  self errorDetails: (str := String new ).
  ^ self buildMessageText: str .
]

{ #category : 'Accessing' }
CompileError >> errorDetails [
  ^ self errorDetails: nil
]

{ #category : 'Accessing' }
CompileError >> errorDetails: resStr [
  "Returns an Array of error details.
   Fill in the error message for each element of the error details,
   as a side effect of returning the error details.
   Append the text of each element to a non-nil resStr ."
  gsArgs ifNotNil:[ :arr |
    (arr atOrNil: 1) ifNotNil:[ :errorArrays | | numErrs n |
       numErrs := errorArrays size .
       n := 1 .
       [ n <= numErrs ] whileTrue:[ | anErr msg |
         anErr := errorArrays at: n .
         (msg := anErr atOrNil: 3) ifNil:[ "message not yet filled in" | errNum |
            (errNum := anErr atOrNil: 1 ) _isSmallInteger ifTrue:[
              msg := LegacyErrNumMap atOrNil: errNum .
              msg _isOneByteString ifFalse:[ msg := 'unknown compiler error'].
              anErr at: 3 put: msg .
            ]
          ] ifNotNil:[ "messages already filled in"
            resStr ifNil:[ n := numErrs "early exit" ]
          ].
          resStr ifNotNil:[
            n > 1 ifTrue:[ resStr add:'; ' ].
            resStr add: msg ; add: $  .
            (anErr atOrNil: 4) ifNotNil:[:v | resStr add: $  ; add: v ].
            (anErr atOrNil: 5) ifNotNil:[:v | resStr add: $  ; add: v ].
          ].
          n := n + 1 .
       ].
       ^ errorArrays
    ].
  ].
  ^ { { 1075"STDB_MALFORMED_COMPILER_ERROR" . 1 . 'malformed CompilerError'  } }

]

{ #category : 'Private' }
CompileError >> gsArguments [
  | ed |
  ed := self errorDetails "ensure error details are populated" .
  ^ gsArgs ifNil:[ { ed . nil"no source string" } ].

]
