"
Instances of this class represent records in a ZoneInfo database.
It describes characteristics of a transition to/from DST.
"
Class {
	#name : 'TimeZoneTransition',
	#superclass : 'Object',
	#instVars : [
		'transitionTime',
		'offsetFromUTC',
		'isDST',
		'abbreviation'
	],
	#category : 'TimeRelated'
}

{ #category : 'other' }
TimeZoneTransition >> = aTimeZoneTransition [

	^(aTimeZoneTransition isKindOf: TimeZoneTransition)
		and: [self transitionTimeUTC	= aTimeZoneTransition transitionTimeUTC
		and: [self offsetFromUTC 		= aTimeZoneTransition offsetFromUTC
		and: [self isDST 					= aTimeZoneTransition isDST
		and: [self abbreviation 		= aTimeZoneTransition abbreviation]]]].

]

{ #category : 'other' }
TimeZoneTransition >> abbreviation [

	^abbreviation.

]

{ #category : 'other' }
TimeZoneTransition >> asDateAndTimeUTC [

	^DateAndTime
		posixSeconds: transitionTime
		offset: Duration zero.

]

{ #category : 'other' }
TimeZoneTransition >> hash [

	^transitionTime hash.

]

{ #category : 'other' }
TimeZoneTransition >> isDST [

	^isDST.

]

{ #category : 'other' }
TimeZoneTransition >> localTimeTypeID: anInteger [
	"Borrow the offsetFromUTC instance variable for a moment"

	offsetFromUTC := anInteger.

]

{ #category : 'other' }
TimeZoneTransition >> offsetFromUTC [

	^offsetFromUTC.

]

{ #category : 'other' }
TimeZoneTransition >> printOn: aStream [

	| dt duration |
	duration := Duration seconds: offsetFromUTC.
	dt := DateAndTime
		posixSeconds: transitionTime
		offset: duration.
	dt printOn: aStream.
	aStream space.
	duration printOnHoursMinutes: aStream.
	aStream space.
	abbreviation printOn: aStream.

]

{ #category : 'other' }
TimeZoneTransition >> transitionTime: anInteger [

	transitionTime := anInteger.

]

{ #category : 'other' }
TimeZoneTransition >> transitionTimeLocal [

	^transitionTime + offsetFromUTC.

]

{ #category : 'other' }
TimeZoneTransition >> transitionTimeUTC [

	^transitionTime.

]

{ #category : 'other' }
TimeZoneTransition >> typeList: anArray [

	| data |
	data := anArray at: offsetFromUTC.	"temporary use as localTimeTypeID"
	offsetFromUTC := data at: 1.				"now used for its named purpose"
	isDST := data at: 2.
	abbreviation := data at: 3.

]
