Extension { #name : 'SmallTime' }

{ #category : 'Instance Creation' }
SmallTime class >> _now [
  ^ self __now

]

{ #category : 'Instance Creation' }
SmallTime class >> fromMicroseconds: anInteger [
 "Creates and returns an instance of the receiver from the specified value,
  which expresses local time."      "fix 48708"
  <primitive: 1120>
  anInteger _isSmallInteger ifFalse:[ 
     ^ self fromMicroseconds: anInteger asInteger \\ 86400000000 .
  ] ifTrue:[
    anInteger < 0 ifTrue:[
      ^ self fromMicroseconds: anInteger \\ 86400000000 .
    ]
  ].
  ^ Time basicNew _setMilliseconds: (anInteger / 1000.0)
]

{ #category : 'Instance Creation' }
SmallTime class >> fromMilliseconds: anInteger [
  ^ self fromMicroseconds: 1000 * anInteger . 

]

{ #category : 'Converting' }
SmallTime >> asMicroseconds [
  "Returns a SmallInteger that represents the receiver in units of microseconds since
  midnight, local time"
  <primitive: 1119 >
  ^ self _primitiveFailed: #asMicroseconds  

]

{ #category : 'Converting' }
SmallTime >> asMilliseconds [
  "Returns a SmallInteger that represents the receiver in units of milliseconds since
  midnight, local time"
  ^ self asMicroseconds // 1000 

]

{ #category : 'Storing and Loading' }
SmallTime >> containsIdentity [
  ^ true

]

{ #category : 'Testing' }
SmallTime >> isSpecial [
  ^ true

]
