Extension { #name : 'SmallDateAndTime' }

{ #category : 'Private' }
SmallDateAndTime class >> basicNew [
  ^ DateAndTime _basicNew

]

{ #category : 'Storing and Loading' }
SmallDateAndTime class >> loadFrom: passiveObj [
  | inst secs ofs |
  passiveObj readNamedIV.
  secs := passiveObj ivValue.
  secs  isSpecial ifFalse:[  | cls |     "fix 50172"
    (cls := secs class) == ScaledDecimal ifFalse:[ Error signal:'unexpected class ', cls name].
  ].
  passiveObj readNamedIV.
  ofs := passiveObj ivValue.
  ofs  _isSmallInteger ifFalse:[ Error signal:'unexpected ', ofs class name ].
  passiveObj skipNamedInstVars.
  inst := self secondsUTC: secs offsetSeconds: ofs .
  inst isSpecial ifFalse:[ Error signal:'a SmallDateAndTime should be special' ].
  ^ inst
]

{ #category : 'private' }
SmallDateAndTime >> _addSeconds: argSeconds [
  "Return a result of the addition with resolution 0.000001 seconds"
  ^ (self asSeconds + argSeconds) asScaledDecimal: 6 

]

{ #category : 'Accessing' }
SmallDateAndTime >> _offsetSeconds [
  "Returns aSmallInteger "
  <primitive: 1114>
   ^ self _primitiveFailed: #_offsetSeconds 

]

{ #category : 'Accessing' }
SmallDateAndTime >> asSeconds [
  "Returns a ScaledDecimal (or Integer if fractional part is zero)"
  <primitive: 1113>
   ^ self _primitiveFailed: #asSeconds 

]

{ #category : 'Truncation and Rounding' }
SmallDateAndTime >> beRounded [
  "Instances of SmallDateAndTime are invariant, use DateAndTimeANSI >> rounded."
  self shouldNotImplement: #beRounded 
]

{ #category : 'Storing and Loading' }
SmallDateAndTime >> containsIdentity [
  ^ true

]

{ #category : 'comparing' }
SmallDateAndTime >> hash [
  ^ self asSeconds hash

]

{ #category : 'Testing' }
SmallDateAndTime >> isSpecial [
  ^ true

]

{ #category : 'public' }
SmallDateAndTime >> posixSeconds: anInteger [
  "Disallowed because it would change the identity of SmallDateAndTime instances.
   You need to create a new instance instead."

  self shouldNotImplement: #posixSeconds:

]

{ #category : 'Storing and Loading' }
SmallDateAndTime >> writeTo: passiveObj [
   passiveObj writeClass: self class ;
     writeObject: self asSeconds named: #seconds ;
     writeObject: self _offsetSeconds named: #offset ;
     endNamedInstVars ; cr 
]
