"
RcKeyValueDictionary is an AbstractDictionary that shares many of the protocols
 and characteristics of KeyValueDictionary.  Like all dictionaries, it stores
 key/value pairs.  In an RcKeyValueDictionary, keys may be of mixed classes.

 Like KeyValueDictionary, RcKeyValueDictionary stores key/value pairs under an
 index that is generated by applying a hash function to the key; it does not use
 Associations.  The hashing improves retrieval speed.  However, you must observe
 an important restriction: after a key/value pair has been added to an
 RcKeyValueDictionary, you must not modify the key.  Doing so renders the value
 inaccessible.

 An RcKeyValueDictionary is also an equality-based collection.  That is, two
 keys or two values are considered to be the same if they are equivalent; they
 need not be identical to be the same.  Thus, if you add two key-value pairs to
 an RcKeyValueDictionary but the keys are equivalent, even if they are not
 identical, then the result is that the second pair overwrites the first one,
 because the keys are the same.

 However, unlike KeyValueDictionary, RcKeyValueDictionary provides for
 concurrent handling of an individual instance by multiple sessions.  Any or all
 of those sessions can modify the single instance.  When that happens,
 RcKeyValueDictionary also reduces (but does not eliminate) the transaction
 conflicts that can arise among those sessions when they attempt to commit the
 instance to GemStone.

 Commit Conflicts.

 In general, RcKeyValueDictionaries do not cause concurrency conflicts for write
 operations that are commutative (operations that can be performed in any order
 without affecting the final GemStone state).  However, under some circumstances
 a user may experience conflict for commutative operations when the basicSize of
 the dictionary is too small (relative to the number of write operations
 performed in a transaction).  This can be avoided by creating a larger
 dictionary with the new: method, or increasing an existing dictionary's size
 with the rebuildTable: method.

 If multiple users change values for different keys in a single
 RcKeyValueDictionary, the changes do not usually cause conflicts at commit
 time.  However, there is a (narrow and uncommon) window of time over which
 users have no control during which such a set of changes could result in
 conflicts.

Constraints:
	_indexedPaths: Object
	collisionLimitPerBucket: SmallInteger
	[elements]: RcCollisionBucket

instVar collisionLimitPerBucket -- A SmallInteger that represents the number 
 of collisions allowed in a bucket before rebuilding the hash table.
"
Class {
	#name : 'RcKeyValueDictionary',
	#superclass : 'AbstractDictionary',
	#instVars : [
		'_indexedPaths',
		'collisionLimitPerBucket'
	],
	#gs_reservedoop : '87297',
	#category : 'Collections-Dictionaries'
}
