"
Like any counter, an RcCounter maintains an integral value that can be
 incremented or decremented.

 A single instance of RcCounter can be shared among multiple concurrent sessions
 without conflict.  The initial value of the RcCounter at the start of a
 transaction in any session is the last value that has been committed.  During
 their transactions, any or all sessions that share the RcCounter can modify it.
 Each session then sees a value for the RcCounter that reflects only the initial
 value from the start of its own transaction and the changes made in that
 transaction.

 When a session commits the RcCounter, the cumulative changes of other
 transactions committed since the start of the current session's transaction
 are merged with those of the committing transaction.  No commit conflicts
 occur between the sessions.  But the count that a session sees immediately
 before its transaction is committed may not be the same as the count it sees
 immediately after.

Constraints:
	[elements]: RcCounterElement
"
Class {
	#name : 'RcCounter',
	#superclass : 'Object',
	#type : 'variable',
	#gs_reservedoop : '109313',
	#category : 'NumberGenerators'
}
