"
This class is used to represent a user-defined JSON Web Token (JWT) claim.

#jsonKey (Symbol)  - key for the claim in the JWT
#jsonKind (Symbol) - type of JSON object for the value of the key. Must be 
                     one of:
                        #String 
                        #Number
                        #ArrayOfStrings
                        #ArrayOfNumbers
                        #Boolean
#acceptedValues (Array) - an IdentitySet of 1 or more Symbols which will be accepted.
                          Each value must be a Symbol.

Each #jsonKey must exist in the JWT or the login request will be denied.
The value for the JSON key must match one of the elements in the #acceptedValues 
array or the login request will be denied. 
The symbol #* present in acceptedValues acts as a wildcard and means any 
value will be accepted.
For claims with a jsonKind of #ArrayOfStrings, the JWT member for the key may
be either a single String or an Array of strings.
For claims with a jsonKind of #ArrayOfNumbers, the JWT member for the key may
be either a single Number or an Array of Numbers.

No validation checking is done to ensure the #acceptValues are of the appropriate
type, except that each value must understand the #asSymbol message.

"
Class {
	#name : 'JwtUserClaim',
	#superclass : 'Object',
	#instVars : [
		'jsonKey',
		'jsonKind',
		'acceptedValues'
	],
	#category : 'System-LoginSupport'
}
