"
This class is used to manage JSON Web Token (JWT) login credentials for a UserProfile.

  validIssuers   - IdentitySet of Symbols containing acceptable values for the 'iss' JWT member.
  validAudiences - IdentitySet of Symbols containing acceptable values for the 'aud' JWT member.
  userIdKey      - Symbol indicating which member of the JWT acts as the UserId.
  validUserIds   - IdentitySet of Symbols containing acceptable values for UserId.
  userClaims     - Array of zero or more JwtUserClaim objects.

The symbol #* present in any of the above IdentitySets acts as a wildcard and means any 
value will be accepted.
"
Class {
	#name : 'JwtSecurityData',
	#superclass : 'Object',
	#instVars : [
		'validIssuers',
		'validAudiences',
		'userIdKey',
		'validUserIds',
		'userClaims'
	],
	#category : 'System-LoginSupport'
}
