"
BtreeReadStream supports the composition of query results by providing access
 to a B-tree structure.

 A BtreeReadStream can read all the entries of the B-tree one at a time.  Supply
 the root node when you create the stream, and send the 'next' message to
 read the first node.  Send the 'next' message repeatedly to iterate over
 the B-tree's contents, and send the 'atEnd' message to check if there are
 any more nodes.

--- instVar currentStack
An Array of B-tree node / offset pairs.  The successive elements of the
 Array indicate the path through the B-tree to the current entry.

--- instVar endIndex
The SmallInteger index of the leaf node that is the last entry in the B-tree.

--- instVar endNode
The BtreeLeafNode that is the last entry in the B-tree.

"
Class {
	#name : 'BtreeReadStream',
	#superclass : 'Stream',
	#instVars : [
		'endNode',
		'endIndex',
		'currentStack',
		'streamQuerySpec'
	],
	#category : 'Indexing-Btree-Streams'
}
