"
Reflection is an abstract class that has no instances.  It implements class
 methods for object so that it is safe to get information about the object
 without sending it a message.
"
Class {
	#name : 'Reflection',
	#superclass : 'Object',
	#category : 'Kernel-Processes'
}

{ #category : 'Private' }
Reflection class >> _reflect: anObject opCode: anInt [

<primitive: 837 >
anInt _validateClass: SmallInteger.
anInt > 4 ifTrue: [ anInt _error: #rtErrArgOutOfRange "bad opcode" ].
self _primitiveFailed: #_reflect:opcode: args: { anObject . anInt } .

]

{ #category : 'Private' }
Reflection class >> _reflect: anObject opCode: opcodeInt arg: anArg [

<primitive: 838 >
opcodeInt _validateClass: SmallInteger.
opcodeInt > 6 ifTrue: [ opcodeInt _error: #rtErrArgOutOfRange "bad opcode" ].
opcodeInt == 6 ifTrue:[ anArg _validateClass: Symbol ].
self _primitiveFailed: #_reflect:opcode:withArg:
     args: { anObject . opcodeInt . anArg } .

]

{ #category : 'Private' }
Reflection class >> _reflect: anObject opCode: opcodeInt arg1: anArg1 arg2: anArg2 [

<primitive: 839 >
opcodeInt _validateClass: SmallInteger.
opcodeInt > 3 ifTrue: [ opcodeInt _error: #rtErrArgOutOfRange "bad opcode" ].
opcodeInt <= 2 ifTrue:[ anArg1 _validateClass: SmallInteger ]
          ifFalse:[     anArg1 _validateClass: Symbol ].
self _primitiveFailed: #_reflect:opcode:withArg:
     args: { anObject . opcodeInt . anArg1 . anArg2 } .

]

{ #category : 'Accessing' }
Reflection class >> classOf: anObject [
"Answers the class of the object, the object whose
 oop would be returned by GciFetchClass."

^self _reflect: anObject opCode: 2

]

{ #category : 'Accessing' }
Reflection class >> fetchDynamicInstVar: anObject named: aSymbol [

 "Return the value of specified dynamic instance variable, or nil if anObject
  has no such dynamic instance variable.  Does not consider instVars defined
  by the anObject's class.  See Object>>dynamicInstVarAt: "


^self _reflect: anObject opCode: 6 arg: aSymbol

]

{ #category : 'Accessing' }
Reflection class >> fetchFrom: anObject at: anIndex [
" Answers the object or byte found at the given index in the object.
  Legal values for anIndex are 1 to sizeOf: anObject. Not valid for 0-size objects.
  Indices are consistent with GciFetchOop and GciFetchByte."

^self _reflect: anObject opCode: 2 arg: anIndex - 1

]

{ #category : 'Accessing' }
Reflection class >> fetchTagOf: anObject tagNum: tagNumber [

" Answer the object referred to by the given tag number of the object.
  tagNumber must be from 1 to the value reported by tagSizeOf: "

^self _reflect: anObject opCode: 5 arg: tagNumber

]

{ #category : 'Updating' }
Reflection class >> from: anNsc removeObject: anObject [

" Removes an existing object from the NSC. Consistent with
  GciRemoveOopFromNsc.
  Answer true if the object was in the NSC and has been removed, false if the
  object was not present."

^self _reflect: anNsc opCode: 4 arg: anObject

]

{ #category : 'Accessing' }
Reflection class >> implementationOf: anObject [
"Answers #pointers, #bytes, #NSC, or #special, analagous
 to the intergers returned by GciFetchObjImpl."

| impl |
impl := self _reflect: anObject opCode: 3.
(impl == 0) ifTrue: [ ^ #pointers ].
(impl == 1) ifTrue: [ ^ #bytes ].
(impl == 2) ifTrue: [ ^ #NSC ].
(impl == 3) ifTrue: [ ^ #special ].
^ #InvalidImplementation

]

{ #category : 'Accessing' }
Reflection class >> namedSizeOf: anObject [

" Answers 0 if #implementationOf: answers #special.
  Otherwise, answers the number of named instance variables in the object.

  Consistent with GciFetchNamedSize."

^ self _reflect: anObject opCode: 5

]

{ #category : 'Accessing' }
Reflection class >> oopOf: anObject [
"Answers the oop of the object, consistent with Object>>asOop."

^self _reflect: anObject opCode: 1

]

{ #category : 'Updating' }
Reflection class >> setSizeOf: anObject to: newSize [

" Sets the indexable size of anObject so that it will subsequently answer newSize
  when sent sizeOf:. Consistent with GciSetVaryingSize.
  Not valid for #NSC or #special objects."

self _reflect: anObject opCode: 1 arg: newSize

]

{ #category : 'Accessing' }
Reflection class >> sizeOf: anObject [

" Answers 0 if #implementationOf: answers #special.
  Otherwise, answers the number of pointers (for #pointers or #NSC)
    or bytes (#bytes) that the object currently holds.

  For #pointers objects (small and large), this includes both named instance variables
    and the object's varying size.
  Consistent with GciFetchSize. "

^ self _reflect: anObject opCode: 4

]

{ #category : 'Updating' }
Reflection class >> storeDynamicInstVar: anObject named: aSymbol newValue: aValue [

 "Store the value of specified dynamic instance variable,
  If aValue ~~ _remoteNil, creates the dynamic instance variable if needed.
  aValue == _remoteNil effectively removes the instance variable.
  Does not consider instVars defined by the anObject's class.
  Generates an error if anObjectreceiver is an ExecBlock, Behavior, GsNMethod,
  or special object.  See  Object>>dynamicInstVarAt:put: "

self _reflect: anObject opCode: 3 arg1: aSymbol arg2: aValue

]

{ #category : 'Updating' }
Reflection class >> storeTagTo: anObject tagNum: tagNumber newValue: aValue [

" Store the given value into the specified tag number of the object.
  tagNumber must be 1 or 2. Similar to prim 280."

self _reflect: anObject opCode: 2 arg1: tagNumber arg2: aValue

]

{ #category : 'Updating' }
Reflection class >> storeTo: anObject at: anIndex put: aValue [
" Stores aValue, which may be any object for #pointers objects, but which
  must be 0-255 for #byte objects, at the given index in the object.
  Indices are consistent with GciStoreOop and GciStoreByte. Legal indices are 1 to
  sizeOf: anObject."

self _reflect: anObject opCode: 1 arg1: anIndex - 1 arg2: aValue

]

{ #category : 'Accessing' }
Reflection class >> tagSizeOf: anObject [

" Returns the number of words of dynamic instVars in the object."

^ self _reflect: anObject opCode: 6

]

{ #category : 'Updating' }
Reflection class >> to: anNsc addObject: anObject [

" Add a new object to the NSC. Consistent with GciAddOopToNsc."

self _reflect: anNsc opCode: 3 arg: anObject

]
